/*
 * Decompiled with CFR 0.152.
 */
package com.zero.utils.config;

import cn.hutool.core.util.StrUtil;
import eu.bitwalker.useragentutils.Browser;
import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.UserAgent;
import java.lang.reflect.Field;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class Utils {
    private static final Logger log = LogManager.getLogger(Utils.class);
    private static final List<String> IP_ADDRESS = Arrays.asList("0.0.0.0", "0:0:0:0:0:0:0:1", "localhost", "127.0.0.1");
    private static final String UNKNOWN = "unknown";

    public static String getRealIp() {
        String ip;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (!Objects.isNull(requestAttributes)) {
            HttpServletRequest httpServletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
            ip = httpServletRequest.getHeader("X-Real-IP");
            if (ip == null || ip.isEmpty() || UNKNOWN.equalsIgnoreCase(ip)) {
                ip = httpServletRequest.getHeader("X-Forwarded-For");
            }
            if (ip == null || ip.isEmpty() || UNKNOWN.equalsIgnoreCase(ip)) {
                ip = httpServletRequest.getHeader("Proxy-Client-IP");
            }
            if (ip == null || ip.isEmpty() || UNKNOWN.equalsIgnoreCase(ip)) {
                ip = httpServletRequest.getHeader("WL-Proxy-Client-IP");
            }
            if (ip == null || ip.isEmpty() || UNKNOWN.equalsIgnoreCase(ip)) {
                ip = httpServletRequest.getRemoteAddr();
            }
            if (IP_ADDRESS.contains(ip)) {
                ip = Utils.getIpAddress();
            }
        } else {
            ip = Utils.getIpAddress();
        }
        return ip;
    }

    private static String getIpAddress() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String analysisXmlStr(String xml, String tags) {
        block5: {
            try {
                Document doc = DocumentHelper.parseText((String)xml);
                Element rootElt = doc.getRootElement();
                if (StrUtil.isNotBlank((CharSequence)tags)) {
                    String[] split = tags.split("\\.");
                    Element param = null;
                    for (String s : split) {
                        param = Objects.isNull(param) ? rootElt.element(s) : param.element(s);
                    }
                    if (!Objects.isNull(param)) {
                        return param.getText();
                    }
                    break block5;
                }
                return rootElt.getText();
            }
            catch (DocumentException e) {
                e.printStackTrace();
                log.error("\u89e3\u6790\u5931\u8d25xml={}  tags={}", (Object)xml, (Object)tags);
            }
        }
        return null;
    }

    public static Map<String, String> getOsAndBrowserInfo() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        HashMap<String, String> map = new HashMap<String, String>(2);
        if (!Objects.isNull(requestAttributes)) {
            HttpServletRequest httpServletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
            String ua = httpServletRequest.getHeader("User-Agent");
            UserAgent userAgent = UserAgent.parseUserAgentString((String)ua);
            Browser browser = userAgent.getBrowser();
            OperatingSystem os = userAgent.getOperatingSystem();
            map.put("os", os.getName());
            map.put("browser", Objects.equals(browser.getName(), "Unknown") ? ua : browser.getName());
        }
        return map;
    }

    public static String getUuidStr() {
        return UUID.randomUUID().toString();
    }

    public static long getCurrentTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public static void setFieldValueByFieldName(Object object, String fieldName, Object value) {
        try {
            Class<?> c = object.getClass();
            Field field = Utils.getFieldInfo(c, c.getDeclaredFields(), fieldName);
            if (!Objects.isNull(field)) {
                field.setAccessible(true);
                field.set(object, value);
            }
        }
        catch (Exception e) {
            log.warn("\u6839\u636e\u5c5e\u6027\u540d\u8bbe\u7f6e\u5c5e\u6027\u503c {} \u5931\u8d25", (Object)fieldName);
        }
    }

    public static Object getFieldValueByFieldName(String fieldName, Object object) {
        try {
            Class<?> c = object.getClass();
            Field field = Utils.getFieldInfo(c, c.getDeclaredFields(), fieldName);
            if (!Objects.isNull(field)) {
                field.setAccessible(true);
                return field.get(object);
            }
        }
        catch (Exception e) {
            log.warn("\u6839\u636e\u5c5e\u6027\u540d\u83b7\u53d6\u5c5e\u6027\u503c {} \u5931\u8d25", (Object)fieldName);
        }
        return null;
    }

    private static Field getFieldInfo(Class<?> c, Field[] fields, Object fieldName) {
        for (Field field : fields) {
            if (!Objects.equals(fieldName, field.getName())) continue;
            return field;
        }
        Class<?> superclass = c.getSuperclass();
        if (Objects.isNull(superclass)) {
            return null;
        }
        Field[] declaredFields = superclass.getDeclaredFields();
        return Utils.getFieldInfo(superclass, declaredFields, fieldName);
    }
}

