/*
 * Decompiled with CFR 0.152.
 */
package com.zero.utils.config;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisUtil {
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    private static StringRedisTemplate redisTemplate;

    @PostConstruct
    private void init() {
        redisTemplate = this.stringRedisTemplate;
    }

    public static void setExMinutes(String k, String v, long l) {
        redisTemplate.opsForValue().set((Object)k, (Object)v, l, TimeUnit.MINUTES);
    }

    public static void setExSeconds(String k, String v, long l) {
        redisTemplate.opsForValue().set((Object)k, (Object)v, l, TimeUnit.SECONDS);
    }

    public static void set(String k, String v) {
        redisTemplate.opsForValue().set((Object)k, (Object)v);
    }

    public static String getStr(String k) {
        return (String)redisTemplate.opsForValue().get((Object)k);
    }

    public static Long getExpire(String k) {
        return redisTemplate.getExpire((Object)k, TimeUnit.SECONDS);
    }

    public static boolean hasKey(String k) {
        Boolean b = redisTemplate.hasKey((Object)k);
        return null == b ? false : b;
    }

    public static void delKey(String k) {
        redisTemplate.delete((Object)k);
    }

    public static Set<String> keys(String pattern) {
        return redisTemplate.keys((Object)pattern);
    }

    public static void increment(String key, Integer number) {
        redisTemplate.opsForValue().increment((Object)key, (long)number.intValue());
    }

    public static StringRedisTemplate getRedisTemplateObj() {
        return redisTemplate;
    }
}

