/*
 * Decompiled with CFR 0.152.
 */
package com.zero.utils.base;

import com.querydsl.jpa.impl.JPAQueryFactory;
import com.zero.utils.PageResult;
import com.zero.utils.PublicResult;
import com.zero.utils.base.BaseDao;
import com.zero.utils.base.BaseEntity;
import com.zero.utils.base.BaseQuery;
import com.zero.utils.base.IBase;
import com.zero.utils.config.Utils;
import com.zero.utils.enums.ResultEnums;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public abstract class BaseService<E extends BaseEntity<ID>, ID, M extends BaseDao<E, ID>, Q extends BaseQuery>
implements IBase<E, ID, Q> {
    @Autowired
    protected M mapper;
    @Autowired
    protected JPAQueryFactory jpa;

    @Override
    public PublicResult add(E e) {
        long currentTime = Utils.getCurrentTime();
        Utils.setFieldValueByFieldName(e, "id", Utils.getUuidStr());
        Utils.setFieldValueByFieldName(e, "createTime", currentTime);
        Utils.setFieldValueByFieldName(e, "updateTime", currentTime);
        this.mapper.save(e);
        return PublicResult.addOk();
    }

    @Override
    public PublicResult add(E e, Map<String, Object> maps) {
        if (!CollectionUtils.isEmpty(maps)) {
            for (Map.Entry<String, Object> map : maps.entrySet()) {
                Utils.setFieldValueByFieldName(e, map.getKey(), map.getValue());
            }
        }
        this.add(e);
        return PublicResult.addOk();
    }

    @Override
    public PublicResult update(E e) {
        Optional byId = this.mapper.findById(((BaseEntity)e).getKeyId());
        if (!byId.isPresent()) {
            return PublicResult.updateOk();
        }
        Object createTime = Utils.getFieldValueByFieldName("createTime", byId.get());
        Utils.setFieldValueByFieldName(e, "createTime", createTime);
        Utils.setFieldValueByFieldName(e, "updateTime", Utils.getCurrentTime());
        this.mapper.save(e);
        return PublicResult.updateOk();
    }

    @Override
    public PublicResult update(E e, List<String> keys) {
        Optional byId = this.mapper.findById(((BaseEntity)e).getKeyId());
        if (!byId.isPresent()) {
            return PublicResult.updateOk();
        }
        Object createTime = Utils.getFieldValueByFieldName("createTime", byId.get());
        Utils.setFieldValueByFieldName(e, "createTime", createTime);
        if (!CollectionUtils.isEmpty(keys)) {
            for (String key : keys) {
                Object obj = Utils.getFieldValueByFieldName(key, byId.get());
                Utils.setFieldValueByFieldName(e, key, obj);
            }
        }
        Utils.setFieldValueByFieldName(e, "updateTime", Utils.getCurrentTime());
        this.mapper.save(e);
        return PublicResult.updateOk();
    }

    @Override
    public PublicResult<Optional<E>> get(ID id) {
        return PublicResult.queryOk(this.mapper.findById(id));
    }

    @Override
    public PublicResult<List<E>> getByIds(Iterable<ID> ids) {
        return PublicResult.queryOk(this.mapper.findAllById(ids));
    }

    @Override
    public PublicResult<List<E>> list(Q q) {
        return PublicResult.queryOk(StreamSupport.stream(this.mapper.findAll(((BaseQuery)q).predicate(), ((BaseQuery)q).getSort()).spliterator(), false).collect(Collectors.toList()));
    }

    @Override
    public PageResult<List<E>> pageList(Q q) {
        Page all = this.mapper.findAll(((BaseQuery)q).predicate(), ((BaseQuery)q).getPageable());
        return PageResult.builder().code(ResultEnums.QUERY_OK.getKey()).msg(ResultEnums.QUERY_OK.getMsg()).page(((BaseQuery)q).getPage()).pageSize(((BaseQuery)q).getPageSize()).total(all.getTotalElements()).data(all.getContent()).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PublicResult deleteByIds(List<E> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return PublicResult.delFail("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.mapper.deleteInBatch(ids);
        return PublicResult.delOk();
    }
}

