/*
 * Decompiled with CFR 0.152.
 */
package com.zero.utils.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.CollectionUtils;

public abstract class BaseQuery {
    @ApiModelProperty(value="\u7b2c\u51e0\u9875")
    private int page = 1;
    @ApiModelProperty(value="\u663e\u793a\u591a\u5c11\u6761")
    private int pageSize = 10;
    @ApiModelProperty(value="\u6392\u5e8f", example="{\"createTime\":\"desc\",\"zero\":\"asc\"}")
    protected LinkedHashMap<String, String> sortMap;

    private LinkedHashMap<String, String> getSortMap() {
        return CollectionUtils.isEmpty(this.sortMap) ? this.initSort() : this.sortMap;
    }

    protected LinkedHashMap<String, String> initSort() {
        return null;
    }

    public Predicate predicate() {
        return new BooleanBuilder();
    }

    @JsonIgnore
    public Pageable getPageable() {
        return PageRequest.of((int)(this.page - 1), (int)this.pageSize, (Sort)this.getSort());
    }

    @JsonIgnore
    public Sort getSort() {
        Sort sort = Sort.unsorted();
        ArrayList<Sort.Order> orderList = new ArrayList<Sort.Order>();
        LinkedHashMap<String, String> sortMap = this.getSortMap();
        if (!CollectionUtils.isEmpty(sortMap)) {
            for (Map.Entry<String, String> entry : sortMap.entrySet()) {
                String mapKey = entry.getKey();
                String mapValue = entry.getValue();
                Sort.Direction direction = Sort.Direction.ASC;
                if (Sort.Direction.DESC.toString().equalsIgnoreCase(mapValue)) {
                    direction = Sort.Direction.DESC;
                }
                orderList.add(new Sort.Order(direction, mapKey));
            }
        }
        if (!CollectionUtils.isEmpty(orderList)) {
            sort = Sort.by(orderList);
        }
        return sort;
    }

    public BaseQuery() {
    }

    public BaseQuery(int page, int pageSize, LinkedHashMap<String, String> sortMap) {
        this.page = page;
        this.pageSize = pageSize;
        this.sortMap = sortMap;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getPage() {
        return this.page;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setSortMap(LinkedHashMap<String, String> sortMap) {
        this.sortMap = sortMap;
    }
}

