/*
 * Decompiled with CFR 0.152.
 */
package com.zero.utils.base;

import com.zero.utils.LogTag;
import com.zero.utils.PageResult;
import com.zero.utils.PublicResult;
import com.zero.utils.base.BaseEntity;
import com.zero.utils.base.BaseQuery;
import com.zero.utils.base.IBase;
import com.zero.utils.validation.group.Insert;
import com.zero.utils.validation.group.Update;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public class BaseController<E extends BaseEntity<ID>, ID, S extends IBase<E, ID, Q>, Q extends BaseQuery> {
    @Autowired
    protected S service;

    @GetMapping(value={"get"})
    @ApiOperation(value="\u83b7\u53d6\u4e00\u6761", notes="\u901a\u8fc7\u4e3b\u952e\u83b7\u53d6\u4e00\u6761\u4fe1\u606f")
    public PublicResult<Optional<E>> get(@RequestParam(value="id") ID id) {
        return this.service.get(id);
    }

    @GetMapping(value={"getByIds"})
    @ApiOperation(value="\u83b7\u53d6\u591a\u6761", notes="\u901a\u8fc7\u4e3b\u952e\u96c6\u5408\u83b7\u53d6\u591a\u6761\u4fe1\u606f")
    public PublicResult<List<E>> getByIds(@RequestParam(value="ids") List<ID> ids) {
        return this.service.getByIds(ids);
    }

    @PostMapping(value={"list"})
    @ApiOperation(value="\u5217\u8868", notes="\u67e5\u8be2\u6570\u636e\u96c6\u5408")
    public PublicResult<List<E>> list(@RequestBody @Validated Q query) {
        return this.service.list(query);
    }

    @PostMapping(value={"pageList"})
    @ApiOperation(value="\u5206\u9875\u5217\u8868", notes="\u67e5\u8be2\u5206\u9875\u6570\u636e\u96c6\u5408")
    public PageResult<List<E>> pageList(@RequestBody @Validated Q query) {
        return this.service.pageList(query);
    }

    @PostMapping(value={"del"})
    @ApiOperation(value="\u5220\u9664", notes="\u516c\u7528\u5220\u9664\u63a5\u53e3")
    @LogTag
    public PublicResult deleteByIds(@RequestBody List<E> es) {
        return this.service.deleteByIds(es);
    }

    @PostMapping(value={"add"})
    @ApiOperation(value="\u65b0\u589e", notes="\u516c\u7528\u65b0\u589e\u63a5\u53e3")
    @LogTag
    public PublicResult save(@RequestBody @Validated(value={Insert.class}) E entity) {
        return this.service.add(entity);
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539", notes="\u516c\u7528\u4fee\u6539\u63a5\u53e3")
    @LogTag
    public PublicResult update(@RequestBody @Validated(value={Update.class}) E entity) {
        return this.service.update(entity);
    }
}

