/*
 * Decompiled with CFR 0.152.
 */
package com.zero.utils;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public class RsaUtil {
    private static final int KEY_SIZE = 1024;
    public static final String PUBLIC_KEY = "publicKey";
    public static final String PRIVATE_KEY = "privateKey";
    private static Map<String, String> keyMap = new HashMap<String, String>();

    public static void genKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        keyPairGen.initialize(1024, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        String publicKeyString = Base64.getEncoder().encodeToString(publicKey.getEncoded());
        String privateKeyString = Base64.getEncoder().encodeToString(privateKey.getEncoded());
        keyMap.put(PUBLIC_KEY, publicKeyString);
        keyMap.put(PRIVATE_KEY, privateKeyString);
    }

    public static String encrypt(String str, String publicKey) {
        try {
            byte[] decoded = Base64.getDecoder().decode(publicKey);
            RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, pubKey);
            return Base64.getEncoder().encodeToString(cipher.doFinal(str.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String decrypt(String str, String privateKey) {
        try {
            byte[] inputByte = Base64.getDecoder().decode(str);
            byte[] decoded = Base64.getDecoder().decode(privateKey);
            RSAPrivateKey priKey = (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, priKey);
            return new String(cipher.doFinal(inputByte));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        long temp = System.currentTimeMillis();
        RsaUtil.genKeyPair();
        System.out.println("\u516c\u94a5:" + keyMap.get(PUBLIC_KEY));
        System.out.println("\u79c1\u94a5:" + keyMap.get(PRIVATE_KEY));
        System.out.println("\u751f\u6210\u5bc6\u94a5\u6d88\u8017\u65f6\u95f4:" + (double)(System.currentTimeMillis() - temp) / 1000.0 + "\u79d2");
        String message = "RSA\u6d4b\u8bd5ABCD~!@#$";
        System.out.println("\u539f\u6587:" + message);
        temp = System.currentTimeMillis();
        String messageEn = RsaUtil.encrypt(message, keyMap.get(PUBLIC_KEY));
        System.out.println("\u5bc6\u6587:" + messageEn);
        System.out.println("\u52a0\u5bc6\u6d88\u8017\u65f6\u95f4:" + (double)(System.currentTimeMillis() - temp) / 1000.0 + "\u79d2");
        temp = System.currentTimeMillis();
        String messageDe = RsaUtil.decrypt(messageEn, keyMap.get(PRIVATE_KEY));
        System.out.println("\u89e3\u5bc6:" + messageDe);
        System.out.println("\u89e3\u5bc6\u6d88\u8017\u65f6\u95f4:" + (double)(System.currentTimeMillis() - temp) / 1000.0 + "\u79d2");
    }
}

