/*
 * Decompiled with CFR 0.152.
 */
package com.zero.utils;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.support.ExcelTypeEnum;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.multipart.MultipartFile;

public class EasyExcelUtils {
    public static <T> List<T> easyExcelSyncImport(MultipartFile file, Class<?> excel) throws IOException {
        return EasyExcel.read((InputStream)file.getInputStream()).head(excel).sheet().doReadSync();
    }

    public static <T> List<T> easyExcelSyncImport(MultipartFile file, Class<?> excel, Integer headRowNumber) throws IOException {
        return EasyExcel.read((InputStream)file.getInputStream()).head(excel).sheet().headRowNumber(headRowNumber).doReadSync();
    }

    public static void easyExcelExport(HttpServletResponse response, Class<?> excel, List<?> data, String fileName) throws IOException {
        EasyExcelUtils.easyExcelExport(response, excel, data, fileName, null);
    }

    public static void easyExcelExport(HttpServletResponse response, Class<?> excel, List<?> data, String fileName, String sheet) throws IOException {
        EasyExcelUtils.downLoadExcel(response, fileName);
        EasyExcel.write((OutputStream)response.getOutputStream(), excel).sheet(StrUtil.isNotBlank((CharSequence)sheet) ? sheet : "zero").doWrite(data);
    }

    private static void downLoadExcel(HttpServletResponse response, String fileName) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String encode = URLEncoder.encode(StrUtil.isNotBlank((CharSequence)fileName) ? fileName : "zero", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + encode + ExcelTypeEnum.XLSX.getValue());
    }
}

