package com.zero.utils.validation.validator;

import cn.hutool.core.util.StrUtil;
import com.zero.utils.validation.annotation.Equals;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Objects;

/**
 * @author zero
 */
public class EqualsValidator implements ConstraintValidator<Equals, Object> {
    private String valueStr;
    private int valueInt;

    @Override
    public void initialize(Equals equals) {
        valueStr = equals.valueStr();
        valueInt = equals.valueInt();
    }

    @Override
    public boolean isValid(Object s, ConstraintValidatorContext constraintValidatorContext) {
        if (StrUtil.isNotBlank(valueStr)) {
            return Objects.equals(s, valueStr);
        } else {
            return Objects.equals(s, valueInt);
        }
    }
}
