package com.zero.utils.validation.annotation;

import com.zero.utils.validation.validator.EqualsValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.*;

/**
 * 当值等于什么的时候进行验证
 *
 * @author zero
 */
@Constraint(validatedBy = {EqualsValidator.class})
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.ANNOTATION_TYPE, ElementType.METHOD, ElementType.FIELD})
public @interface Equals {
    // 提示信息
    String message();

    // 值是字符串
    String valueStr() default "";

    // 值是int
    int valueInt() default 0;

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
