package com.zero.utils.enums;

import lombok.Getter;
import lombok.Setter;

/**
 * 接口返回信息枚举
 *
 * @author zero
 */
public enum ResultEnums {
    /**
     * 跳转到登录页面的code为0
     */
    UN_LOGIN_0(0, "需要登录系统"),
    TOKEN_AUTHENTICATION_0(0, "Token认证出现异常"),
    TOKEN_INVALID_0(0, "Token失效"),
    TOKEN_ANALYSIS_0(0, "解析Token出现异常"),
    TOKEN_ENCRYPTION_0(0, "生成Token出现异常"),
    /**
     * 200为正常
     */
    OK(200, "操作成功"),
    LOGIN_OK(200, "登录成功"),
    LOGOUT_OK(200, "退出成功"),
    QUERY_OK(200, "查询成功"),
    ADD_OK(200, "新增成功"),
    UPDATE_OK(200, "更新成功"),
    DEL_OK(200, "删除成功"),
    GEN_OK(200, "代码生成成功"),
    EXPORT_OK(200, "导出成功"),
    IMPORT_OK(200, "导入成功"),
    /**
     * 400接口参数没通过或者业务验证没通过
     */
    FAIL(400, "操作失败"),
    QUERY_FAIL(400, "查询失败"),
    ADD_FAIL(400, "新增失败"),
    UPDATE_FAIL(400, "更新失败"),
    DEL_FAIL(400, "删除失败"),
    LOGOUT_FAIL(400, "退出失败，没有获取到登录信息"),
    PASSWORD(400, "用户密码错误"),
    USER_NOT_EXIST(400, "用户不存在"),
    DATA_VERIFICATION(400, "数据校验异常"),
    NOT_SUPPORTED(400, "请求方法不支持"),
    REQUEST_PARAMETER(400, "接口必传参数未传"),
    MESSAGE_NOT_READABLE(400, "缺少必需的请求正文"),
    MEDIA_TYPE(400, "Content type不支持"),
    USER_NOT_POWER(400, "您没有任何权限"),
    USER_DISABLE(400, "账号被禁用"),
    CAPTCHA_FAIL(400, "验证码错误"),
    CONVERT_FAIL(400, "参数转换异常"),
    /**
     * 401没有权限
     */
    UNAUTHORIZED(401, "没有权限访问"),
    /**
     * 404,405 接口不存在和服务器出错
     */
    NOT_FOUND(404, "接口不存在"),
    EXPORT_FAIL(500, "导出失败"),
    IMPORT_FAIL(500, "导入失败"),
    INTERNAL_SERVER_ERROR(500, "服务器出错");
    @Getter
    @Setter
    private int key;

    @Getter
    @Setter
    private String msg;

    ResultEnums(int key, String msg) {
        this.key = key;
        this.msg = msg;
    }
}
