package com.zero.utils.enums;

import lombok.Getter;
import lombok.Setter;

/**
 * 登录redis相关key
 *
 * @author zero
 */
public enum LoginRedisEnums {
    /**
     * 访问接口使用token
     */
    ACCESS_TOKEN_PREFIX("login:accessToken:%s"),
    /**
     * 缓存的token（处理并发请求）
     */
    CACHE_TOKEN_PREFIX("login:cacheToken:%s"),
    /**
     * 刷新token存生成token的时间戳
     */
    REFRESH_ACCESS_TOKEN_PREFIX("login:refreshToken:%s"),
    /**
     * 验证码KEY
     */
    CAPTCHA_KEY("login:captcha:%s"),
    /**
     * 登录错误key
     */
    LOGIN_FAIL("login:fail:%s"),
    /**
     * 登录错误锁住key
     */
    LOGIN_FAIL_LOCK("login:failLock:%s");

    @Getter
    @Setter
    private String value;

    LoginRedisEnums(String value) {
        this.value = value;
    }
}
