package com.zero.utils.enums;

import lombok.Getter;
import lombok.Setter;

/**
 * jwt相关枚举
 *
 * @author zero
 */
public enum JwtEnums {
    /**
     * access_token 名字
     */
    ACCESS_TOKEN_NAME("Authorization"),
    /**
     * token的加密的密钥(用来加密的盐值)
     */
    SECRET_KEY("zero"),
    /**
     * token中的识别码，也就是用户登录的账号
     */
    MAME("name"),
    /**
     * token中的创建时间戳
     */
    CURRENT_TIME_MILLIS("currentTimeMillis"),
    /**
     * token 中的ip
     */
    IP("ip"),
    /**
     * redis过期时间（单位:秒）
     */
    REDIS_EXPIRE_TIME(30 * 60),
    /**
     * 缓存的token过期时间（单位:秒）
     */
    CACHE_TOKEN_EXPIRE_TIME(20),
    /**
     * jwt 过期时间（单位:秒）
     */
    JWT_EXPIRE_TIME(5 * 60),
    /**
     * 验证码过期时间
     */
    CAPTCHA_EXPIRE_TIME(5 * 60);

    @Getter
    @Setter
    private int intKey;
    @Getter
    @Setter
    private String value;

    JwtEnums(int intKey) {
        this.intKey = intKey;
    }

    JwtEnums(String value) {
        this.value = value;
    }
}
