package com.zero.utils.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * redis工具类
 *
 * @author zero
 */
@Component
public class RedisUtil {
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    private static StringRedisTemplate redisTemplate;

    @PostConstruct
    private void init() {
        redisTemplate = stringRedisTemplate;
    }

    /**
     * 设置redis过期(单位:分)
     *
     * @param k key
     * @param v value
     * @param l 分钟
     */
    public static void setExMinutes(String k, String v, long l) {
        redisTemplate.opsForValue().set(k, v, l, TimeUnit.MINUTES);
    }

    /**
     * 设置redis过期(单位:秒)
     *
     * @param k key
     * @param v value
     * @param l 分钟
     */
    public static void setExSeconds(String k, String v, long l) {
        redisTemplate.opsForValue().set(k, v, l, TimeUnit.SECONDS);
    }

    /**
     * 设置redis永不过期
     *
     * @param k key
     * @param v value
     */
    public static void set(String k, String v) {
        redisTemplate.opsForValue().set(k, v);
    }

    /**
     * 通过key获取value
     *
     * @param k key
     * @return 返回value值
     */
    public static String getStr(String k) {
        return redisTemplate.opsForValue().get(k);
    }

    /**
     * 通过key获取过期时间
     *
     * @param k key
     * @return 时间（秒） 返回0代表永久有效
     */
    public static Long getExpire(String k) {
        return redisTemplate.getExpire(k, TimeUnit.SECONDS);
    }

    /**
     * 判断key是否存在
     *
     * @param k key
     */
    public static boolean hasKey(String k) {
        Boolean b = redisTemplate.hasKey(k);
        return null == b ? false : b;
    }

    /**
     * 通过key删除缓存
     *
     * @param k
     */
    public static void delKey(String k) {
        redisTemplate.delete(k);
    }

    /**
     * 获取通配符下所有key
     *
     * @param pattern
     */
    public static Set<String> keys(String pattern) {
        return redisTemplate.keys(pattern);
    }

    /**
     * 增加
     *
     * @param key
     * @param number
     */
    public static void increment(String key, Integer number) {
        redisTemplate.opsForValue().increment(key, number);
    }

    public static StringRedisTemplate getRedisTemplateObj() {
        return redisTemplate;
    }

}
