package com.zero.utils.base;

import com.zero.utils.PageResult;
import com.zero.utils.PublicResult;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 其他接口基类
 *
 * @author zero
 */
@Repository
public interface IBase<E extends BaseEntity<ID>, ID, Q extends BaseQuery> {


    /**
     * 获取一条
     *
     * @param id 主键
     * @return PublicResult
     */
    PublicResult<Optional<E>> get(ID id);

    /**
     * 多个主键获取
     *
     * @param ids 主键集合
     * @return PublicResult
     */
    PublicResult<List<E>> getByIds(Iterable<ID> ids);

    /**
     * 不分页list
     *
     * @param q 条件类
     * @return PublicResult
     */
    PublicResult<List<E>> list(Q q);

    /**
     * 分页list
     *
     * @param q 条件类
     * @return PageResult
     */
    PageResult<List<E>> pageList(Q q);

    /**
     * 新增
     *
     * @param e 实体类
     * @return PublicResult
     */
    PublicResult add(E e);

    /**
     * 新增
     *
     * @param e    实体类
     * @param maps 前端不能新增的字段，为了让数据完全由后端控制
     *             当然也可以不使用该方法，子类通过querydsl来控制新增字段
     *             这里只是提供一个公共的解决方案
     * @return PublicResult
     */
    PublicResult add(E e, Map<String, Object> maps);

    /**
     * 更新
     *
     * @param e 实体类
     * @return PublicResult
     */
    PublicResult update(E e);

    /**
     * 更新
     *
     * @param e    实体类
     * @param keys 前端不能修改的字段，为了让数据完全由后端控制
     *             当然也可以不使用该方法，子类通过querydsl来控制修改字段
     *             这里只是提供一个公共的解决方案
     * @return PublicResult
     */
    PublicResult update(E e, List<String> keys);

    /**
     * 批量删除
     *
     * @param es 实体集合
     * @return PublicResult
     */
    PublicResult deleteByIds(List<E> es);
}
