package com.zero.utils.base;


import com.zero.utils.Consts;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.NotBlank;

/**
 * 树形结构表数据基类
 *
 * @author zero
 */
@Getter
@Setter
@MappedSuperclass
public abstract class BaseTreeEntity extends BaseDataEntity {
    @Column(name = "parent_id")
    @ApiModelProperty("父级ID")
    @NotBlank(groups = ParentGroup.class, message = "父级ID必填")
    private String parentId = Consts.TREE_DEF_PARENT;

    @Column(name = "parent_ids")
    @ApiModelProperty("父级ID集")
    @NotBlank(groups = ParentGroup.class, message = "父级ID集必填")
    private String parentIds = Consts.TREE_DEF_PARENT;


    public interface ParentGroup {
    }
}
