package com.zero.utils.base;


import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.NotBlank;

/**
 * 普通结构表数据基类
 * MappedSuperclass映射父类的属性到数据库
 *
 * @author zero
 */
@Getter
@Setter
@MappedSuperclass
public abstract class BaseDataEntity extends BaseEntity<String> {
    @Id
    @Column(name = "id", nullable = false)
    @ApiModelProperty("主键")
    private String id;

    @Column(name = "name")
    @ApiModelProperty("名称")
    @NotBlank(message = "名称必填")
    private String name;

    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Long createTime;

    @Column(name = "update_time")
    @ApiModelProperty("修改时间")
    private Long updateTime;

    @Column(name = "remarks")
    @ApiModelProperty("备注")
    private String remarks;

    @Override
    public String getKeyId() {
        return this.id;
    }
}
