package com.zero.utils;

import lombok.Getter;
import lombok.Setter;
import org.apache.commons.collections.CollectionUtils;

import java.util.*;

/**
 * @author zero
 */
@Setter
@Getter
public class TreeNode {
    /**
     * 主键
     */
    public String id;
    /**
     * 父级编号
     */
    private String parentId;
    /**
     * 名称
     */
    private String name;
    /**
     * 父级编号集
     */
    private String parentIds;
    /**
     * 创建时间
     */
    private Long createTime;
    /**
     * 备注
     */
    private String remarks;
    /**
     * 子节点
     */
    private List children = null;

    /**
     * 将所有数据查询到内存中，在处理成树形，数据量大不建议使用
     *
     * @param list 数据
     * @param <T>
     * @return
     */
    @SuppressWarnings("ALL")
    public static <T extends TreeNode> List<T> handleTree(List<T> list) {
        List<T> resultList = new ArrayList<>();
        Map<String, T> dtoMap = new LinkedHashMap<>(list.size());
        for (T node : list) {
            dtoMap.put(node.getId(), node);
        }
        for (Map.Entry<String, T> entry : dtoMap.entrySet()) {
            T node = entry.getValue();
            if (Objects.equals(Consts.TREE_DEF_PARENT, node.getParentId())) {
                // 如果是顶层节点，直接添加到结果集合中
                resultList.add(node);
            } else {
                // 如果不是顶层节点，找其父节点，并且添加到父节点的子节点集合中
                if (!Objects.isNull(dtoMap.get(node.getParentId()))) {
                    if (CollectionUtils.isEmpty(dtoMap.get(node.getParentId()).getChildren())) {
                        List<T> children = new ArrayList<>();
                        children.add(node);
                        dtoMap.get(node.getParentId()).setChildren(children);
                    } else {
                        dtoMap.get(node.getParentId()).getChildren().add(node);
                    }
                }
            }
        }
        return resultList;
    }

}
