package com.zero.utils;

import com.zero.utils.enums.ResultEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

/**
 * 返回数据封装类
 *
 * @author zero
 */
@Getter
@Setter
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("接口返回数据")
public class PublicResult<T> {
    @ApiModelProperty("状态码")
    private int code;

    @ApiModelProperty("错误或失败提示")
    private String msg;

    @ApiModelProperty("详细信息")
    private T data;

    public static <T> PublicResult<T> queryOk(T data) {
        return PublicResult.resultEnums(ResultEnums.QUERY_OK, data);
    }

    public static PublicResult delOk() {
        return PublicResult.resultEnums(ResultEnums.DEL_OK);
    }

    public static PublicResult updateOk() {
        return PublicResult.resultEnums(ResultEnums.UPDATE_OK);
    }

    public static PublicResult addOk() {
        return PublicResult.resultEnums(ResultEnums.ADD_OK);
    }

    public static PublicResult ok() {
        return PublicResult.resultEnums(ResultEnums.OK);
    }

    public static <T> PublicResult<T> queryFail(T data) {
        return PublicResult.resultEnums(ResultEnums.QUERY_FAIL, data);
    }

    public static <T> PublicResult<T> delFail(T data) {
        return PublicResult.resultEnums(ResultEnums.DEL_FAIL, data);
    }

    public static <T> PublicResult<T> updateFail(T data) {
        return PublicResult.resultEnums(ResultEnums.UPDATE_FAIL, data);
    }

    public static <T> PublicResult<T> addFail(T data) {
        return PublicResult.resultEnums(ResultEnums.ADD_FAIL, data);
    }

    public static <T> PublicResult<T> fail(T data) {
        return PublicResult.resultEnums(ResultEnums.FAIL, data);
    }

    public static <T> PublicResult<T> fail(String msg, T data) {
        return PublicResult.<T>builder().code(ResultEnums.FAIL.getKey()).msg(msg).data(data).build();
    }

    public static <T> PublicResult<T> resultEnums(ResultEnums resultEnums, T data) {
        return PublicResult.<T>builder().code(resultEnums.getKey()).msg(resultEnums.getMsg()).data(data).build();
    }

    public static PublicResult resultEnums(ResultEnums resultEnums) {
        return resultEnums(resultEnums, null);
    }

}
