package com.zero.utils;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

/**
 * 返回分页封装对象
 *
 * @author zero
 */
@Getter
@Setter
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("分页返回对象")
public class PageResult<T> {

    @ApiModelProperty("状态码")
    private int code;

    @ApiModelProperty("错误或失败提示")
    private String msg;

    @ApiModelProperty("第几页")
    private int page;

    @ApiModelProperty("显示多少条")
    private int pageSize;

    @ApiModelProperty("总共多少条")
    private long total;

    @ApiModelProperty("详细信息")
    private T data;
}