package com.zero.utils;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.support.ExcelTypeEnum;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.List;

/**
 * easyExcel导出工具
 *
 * @author zero
 */
public class EasyExcelUtils {
    /**
     * 导入数据
     *
     * @param file  读取的文件
     * @param excel excel实体
     * @throws IOException
     */
    public static <T> List<T> easyExcelSyncImport(MultipartFile file, Class<?> excel) throws IOException {
        return EasyExcel.read(file.getInputStream()).head(excel).sheet().doReadSync();
    }

    /**
     * 导入数据
     *
     * @param file          读取的文件
     * @param excel         excel实体
     * @param headRowNumber 设置表头行数
     * @throws IOException
     */
    public static <T> List<T> easyExcelSyncImport(MultipartFile file, Class<?> excel, Integer headRowNumber) throws IOException {
        return EasyExcel.read(file.getInputStream()).head(excel).sheet().headRowNumber(headRowNumber).doReadSync();
    }

    /**
     * 导出数据
     *
     * @param response
     * @param excel    excel实体
     * @param data     数据
     * @param fileName 文件名称
     * @throws IOException
     */

    public static void easyExcelExport(HttpServletResponse response, Class<?> excel, List<?> data, String fileName) throws IOException {
        easyExcelExport(response, excel, data, fileName, null);
    }


    /**
     * 导出数据
     *
     * @param response
     * @param excel    excel实体
     * @param data     数据
     * @param fileName 文件名称
     * @param sheet    工作表名称
     * @throws IOException
     */
    public static void easyExcelExport(HttpServletResponse response, Class<?> excel, List<?> data, String fileName, String sheet) throws IOException {
        downLoadExcel(response, fileName);
        EasyExcel.write(response.getOutputStream(), excel).sheet(StrUtil.isNotBlank(sheet) ? sheet : "zero").doWrite(data);
    }

    /**
     * 下载文件
     *
     * @param response
     * @param fileName
     * @throws IOException
     */
    private static void downLoadExcel(HttpServletResponse response, String fileName) throws IOException {
        // 这里注意 有同学反应使用swagger 会导致各种问题，请直接用浏览器或者用postman
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        // 这里URLEncoder.encode可以防止中文乱码 当然和easyexcel没有关系
        String encode = URLEncoder.encode(StrUtil.isNotBlank(fileName) ? fileName : "zero", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + encode + ExcelTypeEnum.XLSX.getValue());
    }
}
