/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zerowsh.actable.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import io.gitee.zerowsh.actable.dto.ConstraintInfo;
import io.gitee.zerowsh.actable.dto.TableColumnInfo;
import io.gitee.zerowsh.actable.dto.TableInfo;
import io.gitee.zerowsh.actable.emnus.ModelEnums;
import io.gitee.zerowsh.actable.emnus.SqlTypeEnums;
import io.gitee.zerowsh.actable.properties.AcTableProperties;
import io.gitee.zerowsh.actable.service.DatabaseService;
import io.gitee.zerowsh.actable.util.AcTableUtils;
import io.gitee.zerowsh.actable.util.HandlerEntityUtils;
import io.gitee.zerowsh.actable.util.IoUtil;
import io.gitee.zerowsh.actable.util.JdbcUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class AcTableService {
    private static final Logger log = LoggerFactory.getLogger(AcTableService.class);

    private AcTableService() {
    }

    public AcTableService(DataSource dataSource, AcTableProperties acTableProperties) {
        this.acTable(dataSource, acTableProperties);
    }

    public void acTable(DataSource dataSource, AcTableProperties acTableProperties) {
        if (Objects.isNull((Object)acTableProperties.getModel()) || Objects.equals((Object)acTableProperties.getModel(), (Object)ModelEnums.NONE)) {
            log.info("\u81ea\u52a8\u5efa\u8868\u4e0d\u505a\u4efb\u4f55\u64cd\u4f5c\uff01\uff01\uff01");
            return;
        }
        String entityPackage = acTableProperties.getEntityPackage();
        if (StrUtil.isBlank((CharSequence)entityPackage)) {
            log.warn("\u8bf7\u8bbe\u7f6e\u5b9e\u4f53\u7c7b\u5305\u8def\u5f84\uff01\uff01\uff01");
            return;
        }
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            String databaseType = connection.getMetaData().getDatabaseProductName();
            if (StrUtil.isBlank((CharSequence)databaseType)) {
                throw new RuntimeException("\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b\u5931\u8d25\uff01\uff01\uff01");
            }
            List<TableInfo> tableInfoList = HandlerEntityUtils.getTableInfoByEntityPackage(acTableProperties, databaseType);
            if (CollectionUtil.isEmpty(tableInfoList)) {
                log.warn("\u6ca1\u6709\u627e\u5230@Table\u6807\u8bb0\u7684\u7c7b\uff01\uff01\uff01 entityPackage={}", (Object)entityPackage);
                return;
            }
            ModelEnums modelEnums = acTableProperties.getModel();
            ArrayList<String> executeSqlList = new ArrayList<String>();
            this.handleExecuteSql(connection, modelEnums, tableInfoList, executeSqlList, databaseType);
            if (CollectionUtil.isNotEmpty(executeSqlList)) {
                log.info(StrUtil.format((CharSequence)"\u6267\u884c [{}] \u81ea\u52a8\u5efa\u8868\u3002\u3002\u3002", (Object[])new Object[]{databaseType}));
                for (String sql : executeSqlList) {
                    JdbcUtil.executeSql(connection, sql, new Object[0]);
                }
                log.info(StrUtil.format((CharSequence)"\u6267\u884c [{}] \u81ea\u52a8\u5efa\u8868\u5b8c\u6210\uff01\uff01\uff01", (Object[])new Object[]{databaseType}));
            }
            this.executeScript(connection, acTableProperties.getScript(), databaseType);
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u81ea\u52a8\u5efa\u8868\u5f02\u5e38\uff1a", (Throwable)e);
            throw new RuntimeException("\u6267\u884c\u81ea\u52a8\u5efa\u8868\u5f02\u5e38");
        }
        finally {
            IoUtil.close((AutoCloseable)connection);
        }
    }

    public void handleExecuteSql(Connection connection, ModelEnums modelEnums, List<TableInfo> tableInfoList, List<String> executeSqlList, String databaseType) throws SQLException {
        DatabaseService databaseService = AcTableUtils.getDatabaseService(databaseType);
        if (Objects.equals((Object)modelEnums, (Object)ModelEnums.DEL_AND_ADD)) {
            List<String> tableNameList = JdbcUtil.getTableNameList(connection, databaseService.getExecuteSql(SqlTypeEnums.GET_ALL_TABLE), new Object[0]);
            for (String tableName : tableNameList) {
                JdbcUtil.executeSql(connection, databaseService.getExecuteSql(SqlTypeEnums.DROP_TABLE), tableName);
            }
        }
        for (TableInfo tableInfo : tableInfoList) {
            String tableName;
            tableName = tableInfo.getName();
            if (!Objects.equals((Object)modelEnums, (Object)ModelEnums.DEL_AND_ADD) && JdbcUtil.isExist(connection, databaseService.getExecuteSql(SqlTypeEnums.EXIST_TABLE), tableName)) {
                List<TableColumnInfo> tableColumnInfoList = JdbcUtil.getTableColumnInfoList(connection, databaseService.getExecuteSql(SqlTypeEnums.TABLE_STRUCTURE), tableName);
                List<ConstraintInfo> constraintInfoList = JdbcUtil.getConstraintInfoList(connection, databaseService.getExecuteSql(SqlTypeEnums.CONSTRAINT_INFO), tableName);
                List<ConstraintInfo> defaultInfoList = null;
                if (Objects.equals(databaseType, "Microsoft SQL Server")) {
                    defaultInfoList = JdbcUtil.getConstraintInfoList(connection, databaseService.getExecuteSql(SqlTypeEnums.DEFAULT_INFO), tableName);
                }
                executeSqlList.addAll(databaseService.getUpdateTableSql(tableInfo, tableColumnInfoList, constraintInfoList, defaultInfoList, modelEnums));
                continue;
            }
            executeSqlList.addAll(databaseService.getCreateTableSql(tableInfo));
        }
    }

    public void executeScript(Connection connection, String script, String databaseType) {
        if (StrUtil.isBlank((CharSequence)script)) {
            return;
        }
        log.info("\u6267\u884c [{}] \u521d\u59cb\u5316\u6570\u636e\u3002\u3002\u3002", (Object)databaseType);
        for (String s : script.split(",")) {
            try {
                Resource[] resources;
                for (Resource resource : resources = new PathMatchingResourcePatternResolver().getResources("classpath:" + s)) {
                    List<String> strings = this.inputStreamToString(resource.getInputStream());
                    for (String sql : strings) {
                        JdbcUtil.executeSql(connection, sql, new Object[0]);
                    }
                }
            }
            catch (IOException | SQLException e) {
                throw new RuntimeException(StrUtil.format((CharSequence)"\u521d\u59cb\u5316\u6570\u636e\u5931\u8d25\uff0c message={}", (Object[])new Object[]{e.getMessage()}));
            }
        }
        log.info("\u6267\u884c [{}] \u521d\u59cb\u5316\u6570\u636e\u5b8c\u6210\uff01\uff01\uff01", (Object)databaseType);
    }

    public List<String> inputStreamToString(InputStream inputStream) {
        ArrayList<String> resultList = new ArrayList<String>();
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String str;
            StringBuilder oneSql = new StringBuilder();
            while ((str = bufferedReader.readLine()) != null) {
                if (str.contains(");")) {
                    resultList.add(oneSql + str);
                    oneSql = new StringBuilder();
                    continue;
                }
                oneSql.append(str).append("\r\n");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bfb\u53d6\u521d\u59cb\u5316\u6587\u4ef6\u6587\u4ef6\u5f02\u5e38", e);
        }
        return resultList;
    }
}

