/*
 * Decompiled with CFR 0.152.
 */
package com.yunlongn.common.json.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.yunlongn.common.json.jackson.factory.AbstractJsonSerializer;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class LocalDateTimeSerializer
extends AbstractJsonSerializer<LocalDateTime> {
    private int zone;
    private DateTimeFormatter formatter;

    public LocalDateTimeSerializer() {
        this.zone = 8;
        this.formatter = null;
    }

    public LocalDateTimeSerializer(int zone, String datePattern) {
        this.zone = zone;
        if (datePattern == null) {
            this.formatter = null;
            return;
        }
        this.formatter = DateTimeFormatter.ofPattern(datePattern);
    }

    public void serialize(LocalDateTime localDateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.formatter == null) {
            jsonGenerator.writeNumber(localDateTime.toInstant(ZoneOffset.ofHours(this.zone)).toEpochMilli());
        } else {
            jsonGenerator.writeString(localDateTime.format(this.formatter));
        }
    }
}

