/*
 * Decompiled with CFR 0.152.
 */
package com.yunlongn.common.json.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.yunlongn.common.json.jackson.factory.AbstractJsonSerializer;
import com.yunlongn.common.json.util.StringUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateSerializer
extends AbstractJsonSerializer<Date> {
    private SimpleDateFormat sdf;

    public DateSerializer(String datePattern) {
        if (StringUtils.isNullOrEmpty(datePattern)) {
            this.sdf = null;
            return;
        }
        this.sdf = new SimpleDateFormat(datePattern);
    }

    public DateSerializer() {
    }

    public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.sdf == null) {
            jsonGenerator.writeNumber(date.getTime());
        } else {
            jsonGenerator.writeString(this.sdf.format(date));
        }
    }
}

