/*
 * Decompiled with CFR 0.152.
 */
package com.yunlongn.common.json.jackson.factory.impl;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.yunlongn.common.json.jackson.factory.IJacksonExclusion;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JacksonExclusionTransientImpl
extends SimpleFilterProvider
implements IJacksonExclusion {
    private static Set<Class<?>> strategys = new HashSet();
    private static Map<Class<?>, JacksonExclusionTransientImpl> STRATEGY_MAP = new HashMap();

    private static JacksonExclusionTransientImpl createStrategy(Class<?> cla) {
        Field[] fields = cla.getDeclaredFields();
        StringBuilder ignoreFields = new StringBuilder();
        for (Field field : fields) {
            if ((field.getModifiers() & 0x80) != 128) continue;
            if (ignoreFields.length() > 0) {
                ignoreFields.append(",");
            }
            ignoreFields.append(field.getName());
        }
        if (ignoreFields.length() == 0) {
            return null;
        }
        String ignoreStr = ignoreFields.toString();
        JacksonExclusionTransientImpl jacksonExclusionStrategy = new JacksonExclusionTransientImpl();
        jacksonExclusionStrategy.addFilter("myFilter", SimpleBeanPropertyFilter.serializeAllExcept((String[])ignoreStr.split(",")));
        return jacksonExclusionStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JacksonExclusionTransientImpl getInstance(Class<?> cla) {
        JacksonExclusionTransientImpl strategy = STRATEGY_MAP.get(cla);
        if (!STRATEGY_MAP.containsKey(cla)) {
            Class<?> clazz = cla;
            synchronized (clazz) {
                if (!STRATEGY_MAP.containsKey(cla)) {
                    strategy = JacksonExclusionTransientImpl.createStrategy(cla);
                    HashMap newMap = new HashMap(STRATEGY_MAP);
                    newMap.put(cla, strategy);
                    STRATEGY_MAP = newMap;
                }
            }
        }
        return strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExclusionStrategy(Class<?> cla, ObjectMapper objectMapperSub) {
        JacksonExclusionTransientImpl instance = JacksonExclusionTransientImpl.getInstance(cla);
        if (instance == null) {
            return;
        }
        if (strategys.contains(cla)) {
            return;
        }
        ObjectMapper objectMapper = objectMapperSub;
        synchronized (objectMapper) {
            if (strategys.contains(cla)) {
                return;
            }
            HashSet newSet = new HashSet();
            newSet.add(cla);
            strategys = newSet;
            objectMapperSub.setFilterProvider((FilterProvider)instance);
            objectMapperSub.addMixIn(cla, MyFilter.class);
        }
    }

    @JsonFilter(value="myFilter")
    public static interface MyFilter {
    }
}

