/*
 * Decompiled with CFR 0.152.
 */
package com.yunlongn.common.json.jackson.factory;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.yunlongn.common.json.config.JsonConfig;
import com.yunlongn.common.json.jackson.deserializer.DateDeserializer;
import com.yunlongn.common.json.jackson.deserializer.DoubleDeserializer;
import com.yunlongn.common.json.jackson.deserializer.LocalDateTimeDeserializer;
import com.yunlongn.common.json.jackson.deserializer.StringDeserializer;
import com.yunlongn.common.json.jackson.factory.AbstractJsonDeserializer;
import com.yunlongn.common.json.jackson.factory.AbstractJsonSerializer;
import com.yunlongn.common.json.jackson.serializer.DateSerializer;
import com.yunlongn.common.json.jackson.serializer.DoubleSerializer;
import com.yunlongn.common.json.jackson.serializer.LocalDateTimeSerializer;
import com.yunlongn.common.json.jackson.serializer.StringSerializer;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class JsonSerializerFactory {
    public static final Map<Class<?>, AbstractJsonSerializer<?>> ABSTRACT_JSON_SERIALIZERS = new HashMap();
    public static final Map<Class<?>, AbstractJsonDeserializer<?>> ABSTRACT_JSON_DESERIALIZERS = new HashMap();

    public static void addDeserializers(SimpleModule customModule, JsonConfig config) {
        ABSTRACT_JSON_DESERIALIZERS.forEach((key, value) -> {
            value.setConfig(config);
            customModule.addDeserializer(key, (JsonDeserializer)value);
        });
    }

    public static void addSerializers(SimpleModule customModule, JsonConfig config) {
        ABSTRACT_JSON_SERIALIZERS.forEach((key, value) -> {
            value.setConfig(config);
            customModule.addSerializer(key, (JsonSerializer)value);
        });
    }

    static {
        ABSTRACT_JSON_SERIALIZERS.put(Double.class, new DoubleSerializer());
        ABSTRACT_JSON_SERIALIZERS.put(LocalDateTime.class, new LocalDateTimeSerializer());
        ABSTRACT_JSON_SERIALIZERS.put(Date.class, new DateSerializer());
        ABSTRACT_JSON_SERIALIZERS.put(String.class, new StringSerializer());
        ABSTRACT_JSON_DESERIALIZERS.put(Date.class, new DateDeserializer());
        ABSTRACT_JSON_DESERIALIZERS.put(Double.class, new DoubleDeserializer());
        ABSTRACT_JSON_DESERIALIZERS.put(LocalDateTime.class, new LocalDateTimeDeserializer());
        ABSTRACT_JSON_DESERIALIZERS.put(String.class, new StringDeserializer());
    }
}

