/*
 * Decompiled with CFR 0.152.
 */
package com.yunlongn.common.json.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.yunlongn.common.json.AbstractJsonParser;
import com.yunlongn.common.json.TypeReference;
import com.yunlongn.common.json.config.JsonConfig;
import com.yunlongn.common.json.jackson.factory.AbstractJsonSerializer;
import com.yunlongn.common.json.jackson.factory.JacksonExclusionFactory;
import com.yunlongn.common.json.jackson.factory.JsonSerializerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JacksonParser
extends AbstractJsonParser {
    private ObjectMapper objectMapper;
    private Map<String, ObjectMapper> OBJECT_MAPPER_MAP = new HashMap<String, ObjectMapper>();

    public JacksonParser(JsonConfig config) {
        super(config);
    }

    public JacksonParser() {
        super(new JsonConfig());
    }

    @Override
    protected void newJsonParser(JsonConfig jsonConfig) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        SimpleModule customModule = new SimpleModule();
        JsonSerializerFactory.addDeserializers(customModule, this.getConfig());
        objectMapper.registerModule((Module)customModule);
        this.objectMapper = objectMapper;
    }

    private ObjectMapper getObjectMapper(boolean serializeNulls, String datePattern, Map<Class<?>, AbstractJsonSerializer<?>> jsonSerializerMap) {
        StringBuilder key = new StringBuilder((datePattern == null ? "null" : datePattern) + "::" + serializeNulls);
        if (jsonSerializerMap != null) {
            jsonSerializerMap.forEach((className, value) -> key.append("::").append(((Object)value).getClass().getSimpleName()));
        }
        return this.mapperCache(serializeNulls, key.toString(), jsonSerializerMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectMapper mapperCache(boolean serializeNulls, String key, Map<Class<?>, AbstractJsonSerializer<?>> jsonSerializerMap) {
        ObjectMapper objectMapper = this.OBJECT_MAPPER_MAP.get(key);
        if (objectMapper == null) {
            JacksonParser jacksonParser = this;
            synchronized (jacksonParser) {
                objectMapper = this.OBJECT_MAPPER_MAP.get(key);
                if (objectMapper == null) {
                    objectMapper = new ObjectMapper();
                    objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
                    if (!serializeNulls) {
                        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                    }
                    SimpleModule customModule = new SimpleModule();
                    JsonSerializerFactory.addSerializers(customModule, this.getConfig());
                    if (jsonSerializerMap != null) {
                        jsonSerializerMap.forEach((key2, value) -> {
                            value.setConfig(this.getConfig());
                            customModule.addSerializer(key2, (JsonSerializer)value);
                        });
                    }
                    objectMapper.registerModule((Module)customModule);
                    HashMap<String, ObjectMapper> newMap = new HashMap<String, ObjectMapper>(this.OBJECT_MAPPER_MAP);
                    newMap.put(key, objectMapper);
                    this.OBJECT_MAPPER_MAP = newMap;
                }
            }
        }
        return objectMapper;
    }

    @Override
    public <T> String toJsonString(T obj, boolean serializeNulls, String datePattern) {
        try {
            ObjectMapper objectMapper = this.getObjectMapper(serializeNulls, datePattern, null);
            JacksonExclusionFactory.addExclusionStrategy(obj.getClass(), objectMapper);
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> String toJsonString(T obj, boolean serializeNulls, String datePattern, Map<Class<?>, AbstractJsonSerializer<?>> jsonSerializerMap) {
        try {
            ObjectMapper objectMapper = this.getObjectMapper(serializeNulls, datePattern, jsonSerializerMap);
            JacksonExclusionFactory.addExclusionStrategy(obj.getClass(), objectMapper);
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T fromJson(String jsonStr, Class<T> tClass) {
        try {
            return (T)this.objectMapper.readValue(jsonStr, tClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T fromJson(InputStream jsonIn, Class<T> tClass) {
        try {
            return (T)this.objectMapper.readValue(jsonIn, tClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T fromJson(String jsonStr, Type type) {
        try {
            TypeFactory typeFactory = this.objectMapper.getTypeFactory();
            JavaType javaType = typeFactory.constructType(type);
            return (T)this.objectMapper.readValue(jsonStr, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T fromJson(InputStream jsonIn, Type type) {
        try {
            TypeFactory typeFactory = this.objectMapper.getTypeFactory();
            JavaType javaType = typeFactory.constructType(type);
            return (T)this.objectMapper.readValue(jsonIn, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> List<T> fromJsonArray(String jsonStr, final TypeReference<List<T>> typeReference) {
        try {
            return (List)this.objectMapper.readValue(jsonStr, new com.fasterxml.jackson.core.type.TypeReference<List<T>>(){

                public Type getType() {
                    return typeReference.getType();
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

