/*
 * Decompiled with CFR 0.152.
 */
package com.yunlongn.common.json.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.yunlongn.common.json.config.JsonConfig;
import com.yunlongn.common.json.util.DateFormatUtils;
import com.yunlongn.common.json.util.StringUtils;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class LocalDateTimeTypeAdapter
extends TypeAdapter<LocalDateTime> {
    private JsonConfig jsonConfig;
    private int zone = 8;
    private DateTimeFormatter serializerFormatter;

    public LocalDateTimeTypeAdapter(JsonConfig jsonConfig) {
        this.jsonConfig = jsonConfig;
        this.serializerFormatter = null;
        if (jsonConfig.getSerializeConfig() != null) {
            this.serializerFormatter = DateTimeFormatter.ofPattern(jsonConfig.getSerializeConfig().getLocalDateTimeFormat());
        }
    }

    public LocalDateTimeTypeAdapter(String serializerDatePattern) {
        if (StringUtils.isNullOrEmpty(serializerDatePattern)) {
            this.serializerFormatter = null;
            return;
        }
        this.serializerFormatter = DateTimeFormatter.ofPattern(serializerDatePattern);
    }

    public void write(JsonWriter jsonWriter, LocalDateTime time) throws IOException {
        if (this.serializerFormatter == null) {
            jsonWriter.value(time.toInstant(ZoneOffset.ofHours(this.zone)).toEpochMilli());
        } else {
            jsonWriter.value(time.format(this.serializerFormatter));
        }
    }

    public LocalDateTime read(JsonReader jsonReader) throws IOException {
        String datetime = jsonReader.nextString();
        if (StringUtils.isNumber(datetime)) {
            long times = Long.parseLong(datetime);
            if (datetime.length() == 13) {
                times /= 1000L;
            }
            return LocalDateTime.ofEpochSecond(times, 0, ZoneOffset.ofHours(this.zone));
        }
        DateTimeFormatter formatter = DateFormatUtils.chooseDateTimeFormatter(datetime);
        return LocalDateTime.parse(datetime, formatter);
    }
}

