/*
 * Decompiled with CFR 0.152.
 */
package com.yunlongn.common.json.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.yunlongn.common.json.AbstractJsonParser;
import com.yunlongn.common.json.TypeReference;
import com.yunlongn.common.json.config.JsonConfig;
import com.yunlongn.common.json.config.SerializeConfig;
import com.yunlongn.common.json.gson.DateTypeAdapter;
import com.yunlongn.common.json.gson.DoubleTypeAdapter;
import com.yunlongn.common.json.gson.GsonExclusionStrategy;
import com.yunlongn.common.json.gson.LocalDateTimeTypeAdapter;
import com.yunlongn.common.json.gson.StringTypeAdapter;
import com.yunlongn.common.json.jackson.factory.AbstractJsonSerializer;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class GsonParser
extends AbstractJsonParser {
    private Gson gson;
    private ConcurrentMap<String, Gson> gsonMap;

    public GsonParser(JsonConfig config) {
        super(config);
    }

    public GsonParser() {
        super(new JsonConfig());
    }

    @Override
    protected void newJsonParser(JsonConfig jsonConfig) {
        SerializeConfig config = new SerializeConfig();
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTypeAdapter(null)).registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeTypeAdapter(jsonConfig)).registerTypeAdapter(Double.class, (Object)new DoubleTypeAdapter()).registerTypeAdapter(String.class, (Object)new StringTypeAdapter(jsonConfig)).addDeserializationExclusionStrategy((ExclusionStrategy)new GsonExclusionStrategy());
        if (config.isSerializeNulls()) {
            gsonBuilder.serializeNulls();
        }
        this.gson = gsonBuilder.create();
    }

    @Override
    public <T> String toJsonString(T obj, boolean serializeNulls, String pattern) {
        String key = serializeNulls + ":" + pattern;
        Gson gson = (Gson)this.gsonMap.get(key);
        if (gson == null) {
            GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTypeAdapter(pattern)).registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeTypeAdapter(pattern)).registerTypeAdapter(Double.class, (Object)new DoubleTypeAdapter()).registerTypeAdapter(String.class, (Object)new StringTypeAdapter()).addSerializationExclusionStrategy((ExclusionStrategy)new GsonExclusionStrategy());
            if (serializeNulls) {
                gsonBuilder.serializeNulls();
            }
            gson = gsonBuilder.create();
            this.gsonMap.putIfAbsent(key, gson);
        }
        return gson.toJson(obj);
    }

    @Override
    public <T> T fromJson(String jsonStr, Class<T> tClass) {
        return (T)this.gson.fromJson(jsonStr, tClass);
    }

    @Override
    public <T> T fromJson(InputStream jsonIn, Class<T> tClass) {
        return (T)this.gson.fromJson((Reader)new InputStreamReader(jsonIn), tClass);
    }

    @Override
    public <T> T fromJson(String jsonStr, Type type) {
        return (T)this.gson.fromJson(jsonStr, type);
    }

    @Override
    public <T> T fromJson(InputStream jsonIn, Type type) {
        return (T)this.gson.fromJson((Reader)new InputStreamReader(jsonIn), type);
    }

    @Override
    public <T> List<T> fromJsonArray(String jsonStr, TypeReference<List<T>> typeReference) {
        return (List)this.gson.fromJson(jsonStr, typeReference.getType());
    }

    @Override
    public <T> String toJsonString(T obj, boolean serializeNulls, String datePattern, Map<Class<?>, AbstractJsonSerializer<?>> jsonDeserializerMap) {
        return null;
    }
}

