/*
 * Decompiled with CFR 0.152.
 */
package com.yunlongn.common.json.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.yunlongn.common.json.util.DateFormatException;
import com.yunlongn.common.json.util.DateFormatUtils;
import com.yunlongn.common.json.util.DateUtils;
import com.yunlongn.common.json.util.StringUtils;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateTypeAdapter
extends TypeAdapter<Date> {
    private String serializerDatePattern;

    public DateTypeAdapter(String serializerDatePattern) {
        this.serializerDatePattern = serializerDatePattern;
    }

    public void write(JsonWriter jsonWriter, Date date) throws IOException {
        if (date == null) {
            jsonWriter.nullValue();
        } else if (StringUtils.isNullOrEmpty(this.serializerDatePattern)) {
            jsonWriter.value(date.getTime());
        } else {
            String dateFormatAsString = DateUtils.dateToString(date, this.serializerDatePattern);
            jsonWriter.value(dateFormatAsString);
        }
    }

    public Date read(JsonReader jsonReader) throws IOException {
        String datetime = jsonReader.nextString();
        if (StringUtils.isNumber(datetime)) {
            if (datetime.length() == 10) {
                return new Date(Long.parseLong(datetime) * 1000L);
            }
            return new Date(Long.parseLong(datetime));
        }
        try {
            SimpleDateFormat sdf = DateFormatUtils.chooseSimpleDateFormat(datetime);
            return sdf.parse(datetime);
        }
        catch (ParseException e) {
            throw new DateFormatException(datetime);
        }
    }
}

