/*
 * Decompiled with CFR 0.152.
 */
package com.yunlongn.common.json;

import com.yunlongn.common.json.IJsonParser;
import com.yunlongn.common.json.TypeReference;
import com.yunlongn.common.json.config.JsonConfig;
import com.yunlongn.common.json.gson.GsonParser;
import com.yunlongn.common.json.jackson.JacksonParser;
import com.yunlongn.common.json.jackson.factory.AbstractJsonSerializer;
import com.yunlongn.common.json.util.StringUtils;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class JsonUtils {
    public static final AtomicReference<IJsonParser> JSON_PARSER_FACTORY = new AtomicReference<IJsonParser>(JsonUtils.newJsonParserFactory(new JsonConfig()));

    private static IJsonParser newJsonParserFactory(JsonConfig config) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            classLoader.loadClass("com.google.gson.Gson");
            return new GsonParser(config);
        }
        catch (ClassNotFoundException e) {
            try {
                classLoader.loadClass("com.fasterxml.jackson.databind.ObjectMapper");
                return new JacksonParser(config);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("\u672a\u627e\u5230\u4efb\u4f55json\u5305\uff0c\u8bf7\u5148\u5728\u5f53\u524d\u9879\u76ee\u7684\u4f9d\u8d56\u914d\u7f6e\u6587\u4ef6\u4e2d\u52a0\u5165 gson\u6216fackson");
            }
        }
    }

    public static synchronized void resetSerializeConfig(JsonConfig config) {
        JSON_PARSER_FACTORY.set(JsonUtils.newJsonParserFactory(config));
    }

    public static <T> String toJsonString(T obj) {
        return JsonUtils.toJsonString(obj, false, null);
    }

    public static <T> String toJsonString(T obj, boolean serializeNulls) {
        return JsonUtils.toJsonString(obj, serializeNulls, null);
    }

    public static <T> String toJsonString(T obj, boolean serializeNulls, String datePattern) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj == null) {
            return null;
        }
        return JSON_PARSER_FACTORY.get().toJsonString(obj, serializeNulls, datePattern);
    }

    public static <T> String toJsonString(T obj, Map<Class<?>, AbstractJsonSerializer<?>> jsonSerializerMap) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj == null) {
            return null;
        }
        return JSON_PARSER_FACTORY.get().toJsonString(obj, false, null, jsonSerializerMap);
    }

    public static <T> T fromJson(String jsonStr, Class<T> tClass) {
        if (StringUtils.isNullOrEmpty(jsonStr)) {
            return null;
        }
        if (tClass == String.class) {
            return (T)jsonStr;
        }
        return JSON_PARSER_FACTORY.get().fromJson(jsonStr, tClass);
    }

    public static <T> T fromJson(InputStream jsonIn, Class<T> tClass) {
        return JSON_PARSER_FACTORY.get().fromJson(jsonIn, tClass);
    }

    public static <T> T fromJson(String jsonStr, Type type) {
        return JSON_PARSER_FACTORY.get().fromJson(jsonStr, type);
    }

    public static <T> T fromJson(InputStream jsonIn, Type type) {
        return JSON_PARSER_FACTORY.get().fromJson(jsonIn, type);
    }

    public static <T> List<T> fromJsonArray(String jsonStr, TypeReference<List<T>> typeReference) {
        if (StringUtils.isNullOrEmpty(jsonStr)) {
            return null;
        }
        return JSON_PARSER_FACTORY.get().fromJsonArray(jsonStr, typeReference);
    }

    public static <K, V> Map<K, V> fromJsonMap(String jsonStr, TypeReference<Map<K, V>> typeReference) {
        if (StringUtils.isNullOrEmpty(jsonStr)) {
            return null;
        }
        return (Map)JSON_PARSER_FACTORY.get().fromJson(jsonStr, typeReference.getType());
    }

    public static <K, V> Map<K, V> fromJsonMap(InputStream jsonIn, TypeReference<Map<K, V>> typeReference) {
        return (Map)JSON_PARSER_FACTORY.get().fromJson(jsonIn, typeReference.getType());
    }
}

