package com.yunlongn.common.json.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.yunlongn.common.json.config.JsonConfig;
import com.yunlongn.common.json.jackson.factory.AbstractJsonDeserializer;
import com.yunlongn.common.json.jackson.factory.AbstractJsonSerializer;
import com.yunlongn.common.json.util.StringUtils;

import java.io.IOException;
import java.math.BigDecimal;

/**
 * double保留两位小时
 * @author Yun
 * @since 20210902
 */
public class DoubleSerializer extends AbstractJsonSerializer<Double> {


    @Override
    public void serialize(Double aDouble, JsonGenerator jsonGenerator, SerializerProvider serializerProvider)
            throws IOException {
        if (aDouble == null) {
            jsonGenerator.writeNull();
            return;
        }
        jsonGenerator.writeNumber(BigDecimal.valueOf(aDouble)
                .setScale(2, BigDecimal.ROUND_DOWN)
                .doubleValue());
    }

}

