package com.yunlongn.common.json.jackson.factory;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yunlongn.common.json.jackson.factory.impl.JacksonExclusionTransientImpl;

import java.util.ArrayList;
import java.util.List;

public class JacksonExclusionFactory {

    public final static List<IJacksonExclusion> JACKSON_EXCLUSIONS = new ArrayList<>();

    static {
        JACKSON_EXCLUSIONS.add(new JacksonExclusionTransientImpl());
    }

    public static void addExclusionStrategy(Class<?> aClass, ObjectMapper objectMapper) {
        JACKSON_EXCLUSIONS.forEach(jacksonExclusion -> {
            jacksonExclusion.addExclusionStrategy(aClass, objectMapper);
        });
    }
}
