package com.yunlongn.common.json.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.yunlongn.common.json.jackson.factory.AbstractJsonDeserializer;

import java.io.IOException;
/**
 * 字符串反序列化
 * @author Yun
 * @since 20210902
 */
public class StringDeserializer extends AbstractJsonDeserializer<String> {

    @Override
    public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        return jsonParser.getText();
    }

}