package com.yunlongn.common.json.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;

import java.lang.reflect.Modifier;

/**
 * gson 自定义排除策略
 * @author Yun
 * @since 20210902
 */
public class GsonExclusionStrategy implements ExclusionStrategy {

    @Override
    public boolean shouldSkipField(FieldAttributes fieldAttributes) {
        // 排除transient关键字修饰的属性值
        return fieldAttributes.hasModifier(Modifier.TRANSIENT);
    }

    @Override
    public boolean shouldSkipClass(Class<?> aClass) {
        return false;
    }

}
