package com.yunlongn.common.json;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/**
 * 适配gson和jackson
 * @author Yun
 * @since 20210902
 */
public abstract class TypeReference<T> {

    protected final Type _type;

    protected TypeReference() {
        Type superClass = this.getClass().getGenericSuperclass();
        if (superClass instanceof Class) {
            throw new IllegalArgumentException("Internal error: TypeReference constructed without actual type information");
        } else {
            this._type = ((ParameterizedType) superClass).getActualTypeArguments()[0];
        }
    }

    public Type getType() {
        return this._type;
    }

}
