package com.yunlongn.common.json;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.yunlongn.common.json.jackson.factory.AbstractJsonDeserializer;
import com.yunlongn.common.json.jackson.factory.AbstractJsonSerializer;

import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/**
 * @author Yun
 * @since 20210902
 */
public interface IJsonParser {

    <T> String toJsonString(T obj, boolean serializeNulls, String pattern);

    <T> String toJsonString(T obj, boolean serializeNulls, String datePattern, Map<Class<?>, AbstractJsonSerializer<?>> jsonDeserializerMap);

    <T> T fromJson(String jsonStr, Class<T> tClass);

    <T> T fromJson(InputStream jsonIn, Class<T> tClass);

    <T> T fromJson(String jsonStr, Type type);

    <T> T fromJson(InputStream jsonIn, Type type);

    <T> List<T> fromJsonArray(String jsonStr, TypeReference<List<T>> typeReference);


}
