/*
 * Decompiled with CFR 0.152.
 */
package com.yunlongn.common.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.yunlongn.common.json.util.DateFormatUtils;
import com.yunlongn.common.json.util.StringUtils;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

class LocalDateTimeDeserializer
extends JsonDeserializer<LocalDateTime> {
    private int zone;

    public LocalDateTimeDeserializer() {
        this.zone = 8;
    }

    public LocalDateTimeDeserializer(int zone) {
        this.zone = zone;
    }

    public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String datetime = jsonParser.getText();
        if (StringUtils.isNumber(datetime)) {
            long times = Long.parseLong(datetime);
            if (datetime.length() == 13) {
                times /= 1000L;
            }
            return LocalDateTime.ofEpochSecond(times, 0, ZoneOffset.ofHours(this.zone));
        }
        DateTimeFormatter formatter = DateFormatUtils.chooseDateTimeFormatter(datetime);
        return LocalDateTime.parse(datetime, formatter);
    }
}

