/*
 * Decompiled with CFR 0.152.
 */
package com.yunlongn.common.json.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.yunlongn.common.json.JsonParser;
import com.yunlongn.common.json.TypeReference;
import com.yunlongn.common.json.jackson.DateDeserializer;
import com.yunlongn.common.json.jackson.DateSerializer;
import com.yunlongn.common.json.jackson.DoubleDeserializer;
import com.yunlongn.common.json.jackson.DoubleSerializer;
import com.yunlongn.common.json.jackson.JacksonExclusionStrategy;
import com.yunlongn.common.json.jackson.LocalDateTimeDeserializer;
import com.yunlongn.common.json.jackson.LocalDateTimeSerializer;
import com.yunlongn.common.json.jackson.ObjectMapperSub;
import com.yunlongn.common.json.jackson.StringDeserializer;
import com.yunlongn.common.json.jackson.StringSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JacksonParser
implements JsonParser {
    private static final ObjectMapperSub FROM_JSON_JACKSON;
    private static Map<String, ObjectMapperSub> OBJECT_MAPPER_MAP;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectMapperSub getObjectMapper(boolean serializeNulls, String datePattern) {
        String key = (datePattern == null ? "null" : datePattern) + "::" + serializeNulls;
        ObjectMapperSub objectMapper = OBJECT_MAPPER_MAP.get(key);
        if (objectMapper == null) {
            JacksonParser jacksonParser = this;
            synchronized (jacksonParser) {
                objectMapper = OBJECT_MAPPER_MAP.get(key);
                if (objectMapper == null) {
                    objectMapper = new ObjectMapperSub();
                    objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
                    if (!serializeNulls) {
                        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                    }
                    SimpleModule timeModule = new SimpleModule();
                    timeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(8, datePattern));
                    timeModule.addSerializer(Date.class, (JsonSerializer)new DateSerializer(datePattern));
                    timeModule.addSerializer(Double.class, (JsonSerializer)new DoubleSerializer());
                    timeModule.addSerializer(String.class, (JsonSerializer)new StringSerializer());
                    objectMapper.registerModule((Module)timeModule);
                    HashMap<String, ObjectMapperSub> newMap = new HashMap<String, ObjectMapperSub>(OBJECT_MAPPER_MAP);
                    newMap.put(key, objectMapper);
                    OBJECT_MAPPER_MAP = newMap;
                }
            }
        }
        return objectMapper;
    }

    @Override
    public <T> String toJsonString(T obj, boolean serializeNulls, String datePattern) {
        try {
            ObjectMapperSub objectMapper = this.getObjectMapper(serializeNulls, datePattern);
            JacksonExclusionStrategy strategy = JacksonExclusionStrategy.getInstance(obj.getClass());
            if (strategy != null) {
                objectMapper.putStrategy(obj.getClass(), strategy);
            }
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T fromJson(String jsonStr, Class<T> tClass) {
        try {
            return (T)FROM_JSON_JACKSON.readValue(jsonStr, tClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T fromJson(InputStream jsonIn, Class<T> tClass) {
        try {
            return (T)FROM_JSON_JACKSON.readValue(jsonIn, tClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T fromJson(String jsonStr, Type type) {
        try {
            TypeFactory typeFactory = FROM_JSON_JACKSON.getTypeFactory();
            JavaType javaType = typeFactory.constructType(type);
            return (T)FROM_JSON_JACKSON.readValue(jsonStr, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T fromJson(InputStream jsonIn, Type type) {
        try {
            TypeFactory typeFactory = FROM_JSON_JACKSON.getTypeFactory();
            JavaType javaType = typeFactory.constructType(type);
            return (T)FROM_JSON_JACKSON.readValue(jsonIn, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> List<T> fromJsonArray(String jsonStr, final TypeReference<List<T>> typeReference) {
        try {
            return (List)FROM_JSON_JACKSON.readValue(jsonStr, new com.fasterxml.jackson.core.type.TypeReference<List<T>>(){

                public Type getType() {
                    return typeReference.getType();
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        OBJECT_MAPPER_MAP = new HashMap<String, ObjectMapperSub>();
        ObjectMapperSub objectMapper = new ObjectMapperSub();
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        SimpleModule timeModule = new SimpleModule();
        timeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer());
        timeModule.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializer());
        timeModule.addDeserializer(Double.class, (JsonDeserializer)new DoubleDeserializer());
        timeModule.addDeserializer(String.class, (JsonDeserializer)new StringDeserializer());
        objectMapper.registerModule((Module)timeModule);
        FROM_JSON_JACKSON = objectMapper;
    }
}

