/*
 * Decompiled with CFR 0.152.
 */
package com.yunlongn.common.json.jackson;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class JacksonExclusionStrategy
extends SimpleFilterProvider {
    private static Map<Class<?>, JacksonExclusionStrategy> STRATEGY_MAP = new HashMap();

    private JacksonExclusionStrategy() {
    }

    private static JacksonExclusionStrategy createStrategy(Class<?> cla) {
        Field[] fields = cla.getDeclaredFields();
        StringBuilder ignoreFields = new StringBuilder();
        for (Field field : fields) {
            if ((field.getModifiers() & 0x80) != 128) continue;
            if (ignoreFields.length() > 0) {
                ignoreFields.append(",");
            }
            ignoreFields.append(field.getName());
        }
        if (ignoreFields.length() == 0) {
            return null;
        }
        String ignoreStr = ignoreFields.toString();
        JacksonExclusionStrategy jacksonExclusionStrategy = new JacksonExclusionStrategy();
        jacksonExclusionStrategy.addFilter("myFilter", SimpleBeanPropertyFilter.serializeAllExcept((String[])ignoreStr.split(",")));
        return jacksonExclusionStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JacksonExclusionStrategy getInstance(Class<?> cla) {
        JacksonExclusionStrategy strategy = STRATEGY_MAP.get(cla);
        if (strategy == null) {
            Class<?> clazz = cla;
            synchronized (clazz) {
                strategy = STRATEGY_MAP.get(cla);
                if (strategy == null) {
                    strategy = JacksonExclusionStrategy.createStrategy(cla);
                    HashMap newMap = new HashMap(STRATEGY_MAP);
                    newMap.put(cla, strategy);
                    STRATEGY_MAP = newMap;
                }
            }
        }
        return strategy;
    }

    @JsonFilter(value="myFilter")
    public static interface MyFilter {
    }
}

