/*
 * Decompiled with CFR 0.152.
 */
package com.yunlongn.common.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.yunlongn.common.json.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;

class DoubleDeserializer
extends JsonDeserializer<Double> {
    DoubleDeserializer() {
    }

    public Double deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String value = jsonParser.getText();
        if (StringUtils.isNullOrEmpty(value) || "null".equalsIgnoreCase(value)) {
            return null;
        }
        return new BigDecimal(value).setScale(2, 1).doubleValue();
    }
}

