/*
 * Decompiled with CFR 0.152.
 */
package com.yunlongn.common.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.yunlongn.common.json.util.StringUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

class DateSerializer
extends JsonSerializer<Date> {
    private SimpleDateFormat sdf;

    public DateSerializer(String datePattern) {
        if (StringUtils.isNullOrEmpty(datePattern)) {
            this.sdf = null;
            return;
        }
        this.sdf = new SimpleDateFormat(datePattern);
    }

    public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.sdf == null) {
            jsonGenerator.writeNumber(date.getTime());
        } else {
            jsonGenerator.writeString(this.sdf.format(date));
        }
    }
}

