/*
 * Decompiled with CFR 0.152.
 */
package com.yunlongn.common.json.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.yunlongn.common.json.JsonParser;
import com.yunlongn.common.json.TypeReference;
import com.yunlongn.common.json.gson.DateTypeAdapter;
import com.yunlongn.common.json.gson.DoubleTypeAdapter;
import com.yunlongn.common.json.gson.GsonExclusionStrategy;
import com.yunlongn.common.json.gson.LocalDateTimeTypeAdapter;
import com.yunlongn.common.json.gson.StringTypeAdapter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class GsonParser
implements JsonParser {
    private static final Gson FROM_JSON_GSON;
    private static final ConcurrentMap<String, Gson> TO_JSON_GSON_MAP;

    @Override
    public <T> String toJsonString(T obj, boolean serializeNulls, String pattern) {
        String key = serializeNulls + ":" + pattern;
        Gson gson = (Gson)TO_JSON_GSON_MAP.get(key);
        if (gson == null) {
            GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTypeAdapter(pattern)).registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeTypeAdapter(pattern)).registerTypeAdapter(Double.class, (Object)new DoubleTypeAdapter()).registerTypeAdapter(String.class, (Object)new StringTypeAdapter()).addSerializationExclusionStrategy((ExclusionStrategy)new GsonExclusionStrategy());
            if (serializeNulls) {
                gsonBuilder.serializeNulls();
            }
            gson = gsonBuilder.create();
            TO_JSON_GSON_MAP.putIfAbsent(key, gson);
        }
        return gson.toJson(obj);
    }

    @Override
    public <T> T fromJson(String jsonStr, Class<T> tClass) {
        return (T)FROM_JSON_GSON.fromJson(jsonStr, tClass);
    }

    @Override
    public <T> T fromJson(InputStream jsonIn, Class<T> tClass) {
        return (T)FROM_JSON_GSON.fromJson((Reader)new InputStreamReader(jsonIn), tClass);
    }

    @Override
    public <T> T fromJson(String jsonStr, Type type) {
        return (T)FROM_JSON_GSON.fromJson(jsonStr, type);
    }

    @Override
    public <T> T fromJson(InputStream jsonIn, Type type) {
        return (T)FROM_JSON_GSON.fromJson((Reader)new InputStreamReader(jsonIn), type);
    }

    @Override
    public <T> List<T> fromJsonArray(String jsonStr, TypeReference<List<T>> typeReference) {
        return (List)FROM_JSON_GSON.fromJson(jsonStr, typeReference.getType());
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTypeAdapter(null)).registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeTypeAdapter(null)).registerTypeAdapter(Double.class, (Object)new DoubleTypeAdapter()).registerTypeAdapter(String.class, (Object)new StringTypeAdapter()).addDeserializationExclusionStrategy((ExclusionStrategy)new GsonExclusionStrategy());
        FROM_JSON_GSON = gsonBuilder.create();
        TO_JSON_GSON_MAP = new ConcurrentHashMap<String, Gson>();
    }
}

