/*
 * Decompiled with CFR 0.152.
 */
package com.yunlongn.common.json;

import com.yunlongn.common.json.JsonParser;
import com.yunlongn.common.json.TypeReference;
import com.yunlongn.common.json.gson.GsonParser;
import com.yunlongn.common.json.jackson.JacksonParser;
import com.yunlongn.common.json.util.StringUtils;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;

public class JsonUtils {
    private static JsonParser chooseJsonParser;

    public static <T> String toJsonString(T obj) {
        return JsonUtils.toJsonString(obj, false, null);
    }

    public static <T> String toJsonString(T obj, boolean serializeNulls) {
        return JsonUtils.toJsonString(obj, serializeNulls, null);
    }

    public static <T> String toJsonString(T obj, boolean serializeNulls, String datePattern) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj == null) {
            return null;
        }
        return chooseJsonParser.toJsonString(obj, serializeNulls, datePattern);
    }

    public static <T> T fromJson(String jsonStr, Class<T> tClass) {
        if (StringUtils.isNullOrEmpty(jsonStr)) {
            return null;
        }
        if (tClass == String.class) {
            return (T)jsonStr;
        }
        return chooseJsonParser.fromJson(jsonStr, tClass);
    }

    public static <T> T fromJson(InputStream jsonIn, Class<T> tClass) {
        return chooseJsonParser.fromJson(jsonIn, tClass);
    }

    public static <T> T fromJson(String jsonStr, Type type) {
        return chooseJsonParser.fromJson(jsonStr, type);
    }

    public static <T> T fromJson(InputStream jsonIn, Type type) {
        return chooseJsonParser.fromJson(jsonIn, type);
    }

    public static <T> List<T> fromJsonArray(String jsonStr, TypeReference<List<T>> typeReference) {
        if (StringUtils.isNullOrEmpty(jsonStr)) {
            return null;
        }
        return chooseJsonParser.fromJsonArray(jsonStr, typeReference);
    }

    static {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            classLoader.loadClass("com.google.gson.GsonBuilder");
            chooseJsonParser = new GsonParser();
        }
        catch (ClassNotFoundException e) {
            try {
                classLoader.loadClass("com.fasterxml.jackson.databind.ObjectMapper");
                chooseJsonParser = new JacksonParser();
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("\u672a\u627e\u5230\u4efb\u52a1json\u5305\uff0c\u8bf7\u5148\u5728\u5f53\u524d\u9879\u76ee\u7684\u4f9d\u8d56\u914d\u7f6e\u6587\u4ef6\u4e2d\u52a0\u5165 gson\u6216fackson");
            }
        }
    }
}

