/*
 * Decompiled with CFR 0.152.
 */
package com.lwq.sensitive.aspect;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.lwq.sensitive.annotation.SensitiveEnable;
import com.lwq.sensitive.annotation.SensitiveFiled;
import com.lwq.sensitive.enums.SensitiveStrategyEnum;
import com.lwq.sensitive.support.PermissionSupport;
import com.lwq.sensitive.utils.SensitiveUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class SensitiveEnableAspect {
    private static final Logger log = LoggerFactory.getLogger(SensitiveEnableAspect.class);

    @Pointcut(value="@annotation(com.lwq.sensitive.annotation.SensitiveEnable)")
    public void sensitiveEnable() {
    }

    @Around(value="sensitiveEnable()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args;
        long startTime = System.currentTimeMillis();
        Object target = joinPoint.getTarget();
        if (ObjectUtil.isNull((Object)target)) {
            return joinPoint.proceed();
        }
        Class<?>[] parameterTypes = ((MethodSignature)joinPoint.getSignature()).getMethod().getParameterTypes();
        Method method = target.getClass().getMethod(joinPoint.getSignature().getName(), parameterTypes);
        SensitiveEnable annotation = method.getAnnotation(SensitiveEnable.class);
        if (ObjectUtil.isNull((Object)annotation)) {
            return joinPoint.proceed();
        }
        if (!annotation.enableAround()) {
            return joinPoint.proceed();
        }
        PermissionSupport permissionSupport = null;
        if (annotation.enablePermissionSupport()) {
            String beanName = annotation.permissionSupportBeanName();
            try {
                permissionSupport = (PermissionSupport)SpringUtil.getBean((String)beanName);
            }
            catch (Exception e) {
                log.error("\u672a\u83b7\u53d6\u5230\u5bf9\u5e94bean\u4fe1\u606f", (Throwable)e);
            }
            if (null == permissionSupport) {
                try {
                    permissionSupport = (PermissionSupport)SpringUtil.getBean(PermissionSupport.class);
                }
                catch (Exception e) {
                    log.error("\u672a\u83b7\u53d6\u5230\u5bf9\u5e94bean\u4fe1\u606f", (Throwable)e);
                }
                if (null == permissionSupport) {
                    return joinPoint.proceed();
                }
            }
        }
        if (null == (args = joinPoint.getArgs()) && args.length <= 0) {
            return joinPoint.proceed();
        }
        for (Object argItem : args) {
            if (argItem instanceof Collection) {
                Collection collection = (Collection)argItem;
                if (!CollectionUtil.isNotEmpty((Collection)collection)) continue;
                for (Object e : collection) {
                    try {
                        this.decryptSensitive(e, permissionSupport, annotation, argItem);
                    }
                    catch (IllegalAccessException e2) {
                        e2.printStackTrace();
                    }
                }
                continue;
            }
            if (argItem instanceof Map) {
                Map map = (Map)argItem;
                if (!CollectionUtil.isNotEmpty((Map)map)) continue;
                for (Map.Entry entry : map.entrySet()) {
                    try {
                        Object value = entry.getValue();
                        this.decryptSensitive(value, permissionSupport, annotation, argItem);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                continue;
            }
            this.decryptSensitive(argItem, permissionSupport, annotation, argItem);
        }
        log.info("around exeTime ={}", (Object)(System.currentTimeMillis() - startTime));
        return joinPoint.proceed();
    }

    @AfterReturning(value="sensitiveEnable()", returning="result")
    public Object doAfterReturning(JoinPoint joinPoint, Object result) {
        long startTime = System.currentTimeMillis();
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        SensitiveEnable annotation = method.getAnnotation(SensitiveEnable.class);
        if (ObjectUtil.isNull((Object)annotation)) {
            return result;
        }
        if (!annotation.enableAfterReturning()) {
            return result;
        }
        PermissionSupport permissionSupport = null;
        if (annotation.enablePermissionSupport()) {
            String beanName = annotation.permissionSupportBeanName();
            try {
                permissionSupport = (PermissionSupport)SpringUtil.getBean((String)beanName);
            }
            catch (Exception e) {
                log.error("\u672a\u83b7\u53d6\u5230\u5bf9\u5e94bean\u4fe1\u606f", (Throwable)e);
            }
            if (null == permissionSupport) {
                try {
                    permissionSupport = (PermissionSupport)SpringUtil.getBean(PermissionSupport.class);
                }
                catch (Exception e) {
                    log.error("\u672a\u83b7\u53d6\u5230\u5bf9\u5e94bean\u4fe1\u606f", (Throwable)e);
                }
                if (null == permissionSupport) {
                    return result;
                }
            }
        }
        if (result instanceof Collection) {
            Collection collection = (Collection)result;
            if (CollectionUtil.isNotEmpty((Collection)collection)) {
                for (Object e : collection) {
                    try {
                        this.encryptSensitive(e, permissionSupport, annotation, result);
                    }
                    catch (IllegalAccessException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        } else if (result instanceof Map) {
            Map map = (Map)result;
            if (CollectionUtil.isNotEmpty((Map)map)) {
                for (Map.Entry entry : map.entrySet()) {
                    try {
                        Object value = entry.getValue();
                        this.encryptSensitive(value, permissionSupport, annotation, result);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            try {
                this.encryptSensitive(result, permissionSupport, annotation, result);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        log.info("after returning exeTime ={}", (Object)(System.currentTimeMillis() - startTime));
        return result;
    }

    private void encryptSensitive(Object obj, PermissionSupport permissionSupport, SensitiveEnable sensitiveEnableAnnotation, Object objData) throws IllegalAccessException {
        block18: {
            block19: {
                block17: {
                    if (ObjectUtil.isNull((Object)obj)) {
                        return;
                    }
                    if (SensitiveEnableAspect.isBasicTypeObj(obj)) {
                        return;
                    }
                    if (!(obj instanceof List)) break block17;
                    List objList = (List)obj;
                    if (!CollectionUtil.isNotEmpty((Collection)objList)) break block18;
                    for (Object o : objList) {
                        this.encryptSensitive(o, permissionSupport, sensitiveEnableAnnotation, objData);
                    }
                    break block18;
                }
                if (!(obj instanceof Map)) break block19;
                Map objMap = (Map)obj;
                if (!CollectionUtil.isNotEmpty((Map)objMap)) break block18;
                objMap.forEach((key, value) -> {
                    try {
                        this.encryptSensitive(value, permissionSupport, sensitiveEnableAnnotation, objData);
                    }
                    catch (Exception e) {
                        log.error("\u6267\u884c\u51fa\u9519", (Throwable)e);
                    }
                });
                break block18;
            }
            ArrayList<Field> fields = new ArrayList<Field>();
            SensitiveEnableAspect.geteAllFileds(obj, fields);
            if (CollectionUtil.isEmpty(fields)) {
                return;
            }
            for (Field field : fields) {
                SensitiveStrategyEnum strategy;
                SensitiveFiled annotation;
                String name;
                field.setAccessible(true);
                Class<?> type = field.getType();
                if (ObjectUtil.isNotNull(type) && !this.isBasicType(name = type.getName())) {
                    if (type.equals(List.class)) {
                        List list = (List)field.get(obj);
                        if (CollectionUtil.isNotEmpty((Collection)list)) {
                            for (Object e : list) {
                                this.encryptSensitive(e, permissionSupport, sensitiveEnableAnnotation, objData);
                            }
                        }
                    } else if (type.equals(Map.class)) {
                        Map map = (Map)field.get(obj);
                        if (CollectionUtil.isNotEmpty((Map)map)) {
                            for (Map.Entry entry : map.entrySet()) {
                                Object value2 = entry.getValue();
                                this.encryptSensitive(value2, permissionSupport, sensitiveEnableAnnotation, objData);
                            }
                        }
                    } else {
                        try {
                            Object value3 = field.get(obj);
                            this.encryptSensitive(value3, permissionSupport, sensitiveEnableAnnotation, objData);
                        }
                        catch (Exception e) {
                            log.error("error", (Throwable)e);
                        }
                    }
                }
                if (ObjectUtil.isNull((Object)(annotation = field.getAnnotation(SensitiveFiled.class))) || ObjectUtil.isNull((Object)((Object)(strategy = annotation.strategy())))) continue;
                if (sensitiveEnableAnnotation.enablePermissionSupport()) {
                    Predicate<Object> predicate = permissionSupport.doSensitive(objData);
                    if (!predicate.test(obj)) continue;
                    this.doEncrySensitive(obj, field, strategy);
                    continue;
                }
                this.doEncrySensitive(obj, field, strategy);
            }
        }
    }

    private void doEncrySensitive(Object obj, Field field, SensitiveStrategyEnum strategy) throws IllegalAccessException {
        Object o = null;
        try {
            o = field.get(obj);
        }
        catch (Exception e) {
            log.error("handleSensitive error", (Throwable)e);
        }
        String sensitive = null;
        switch (strategy) {
            case USER_NAME: {
                sensitive = SensitiveUtils.userName(ObjectUtil.isNotNull((Object)o) ? o.toString() : null);
                break;
            }
            case ID_CARD: {
                sensitive = SensitiveUtils.idCard(ObjectUtil.isNotNull((Object)o) ? o.toString() : null);
                break;
            }
            case PHONE: {
                sensitive = SensitiveUtils.phone(ObjectUtil.isNotNull((Object)o) ? o.toString() : null);
                break;
            }
            case EMAIL: {
                sensitive = SensitiveUtils.email(ObjectUtil.isNotNull((Object)o) ? o.toString() : null);
                break;
            }
            case BANK_CARD: {
                sensitive = SensitiveUtils.bankCard(ObjectUtil.isNotNull((Object)o) ? o.toString() : null);
                break;
            }
            case EN_CREPT: {
                sensitive = SensitiveUtils.encrypt(o);
            }
        }
        field.set(obj, sensitive);
    }

    private void decryptSensitive(Object obj, PermissionSupport permissionSupport, SensitiveEnable sensitiveEnableAnnotation, Object objData) throws IllegalAccessException {
        block18: {
            block19: {
                block17: {
                    if (ObjectUtil.isNull((Object)obj)) {
                        return;
                    }
                    if (SensitiveEnableAspect.isBasicTypeObj(obj)) {
                        return;
                    }
                    if (!(obj instanceof List)) break block17;
                    List objList = (List)obj;
                    if (!CollectionUtil.isNotEmpty((Collection)objList)) break block18;
                    for (Object o : objList) {
                        this.decryptSensitive(o, permissionSupport, sensitiveEnableAnnotation, objData);
                    }
                    break block18;
                }
                if (!(obj instanceof Map)) break block19;
                Map objMap = (Map)obj;
                if (!CollectionUtil.isNotEmpty((Map)objMap)) break block18;
                objMap.forEach((key, value) -> {
                    try {
                        this.decryptSensitive(value, permissionSupport, sensitiveEnableAnnotation, objData);
                    }
                    catch (Exception e) {
                        log.error("\u6267\u884c\u51fa\u9519", (Throwable)e);
                    }
                });
                break block18;
            }
            ArrayList<Field> fields = new ArrayList<Field>();
            SensitiveEnableAspect.geteAllFileds(obj, fields);
            if (CollectionUtil.isEmpty(fields)) {
                return;
            }
            for (Field field : fields) {
                SensitiveStrategyEnum strategy;
                SensitiveFiled annotation;
                String name;
                field.setAccessible(true);
                Class<?> type = field.getType();
                if (ObjectUtil.isNotNull(type) && !this.isBasicType(name = type.getName())) {
                    if (type.equals(List.class)) {
                        List list = (List)field.get(obj);
                        if (CollectionUtil.isNotEmpty((Collection)list)) {
                            for (Object e : list) {
                                this.decryptSensitive(e, permissionSupport, sensitiveEnableAnnotation, objData);
                            }
                        }
                    } else if (type.equals(Map.class)) {
                        Map map = (Map)field.get(obj);
                        if (CollectionUtil.isNotEmpty((Map)map)) {
                            for (Map.Entry entry : map.entrySet()) {
                                Object value2 = entry.getValue();
                                this.decryptSensitive(value2, permissionSupport, sensitiveEnableAnnotation, objData);
                            }
                        }
                    } else {
                        try {
                            Object value3 = field.get(obj);
                            this.decryptSensitive(value3, permissionSupport, sensitiveEnableAnnotation, objData);
                        }
                        catch (Exception e) {
                            log.error("error", (Throwable)e);
                        }
                    }
                }
                if (ObjectUtil.isNull((Object)(annotation = field.getAnnotation(SensitiveFiled.class))) || ObjectUtil.isNull((Object)((Object)(strategy = annotation.strategy())))) continue;
                if (sensitiveEnableAnnotation.enablePermissionSupport()) {
                    Predicate<Object> predicate = permissionSupport.doSensitive(objData);
                    if (!predicate.test(obj)) continue;
                    this.doDecrySensitive(obj, field, strategy);
                    continue;
                }
                this.doDecrySensitive(obj, field, strategy);
            }
        }
    }

    private void doDecrySensitive(Object obj, Field field, SensitiveStrategyEnum strategy) throws IllegalAccessException {
        if (SensitiveStrategyEnum.EN_CREPT.name().equals(strategy.name())) {
            String decrypt = null;
            try {
                Object o = field.get(obj);
                if (ObjectUtil.isNotNull((Object)o)) {
                    String encryptStr = o.toString();
                    if (encryptStr.contains("$$SENSITIVE$$")) {
                        encryptStr = encryptStr.replace(" ", "+");
                    }
                    decrypt = SensitiveUtils.decrypt(encryptStr);
                }
            }
            catch (Exception e) {
                log.error("handleSensitive error", (Throwable)e);
            }
            field.set(obj, decrypt);
        }
    }

    private static void geteAllFileds(Object obj, List<Field> fieldList) {
        block3: {
            Class<?> clazz;
            block4: {
                block2: {
                    if (!(obj instanceof List)) break block2;
                    List objList = (List)obj;
                    if (!CollectionUtil.isNotEmpty((Collection)objList)) break block3;
                    for (Object o : objList) {
                        SensitiveEnableAspect.geteAllFileds(o, fieldList);
                    }
                    break block3;
                }
                if (!(obj instanceof Map)) break block4;
                Map objMap = (Map)obj;
                if (!CollectionUtil.isNotEmpty((Map)objMap)) break block3;
                objMap.forEach((key, value) -> SensitiveEnableAspect.geteAllFileds(value, fieldList));
                break block3;
            }
            ClassLoader classLoader = clazz.getClassLoader();
            for (clazz = obj.getClass(); clazz != null && ObjectUtil.isNotNull((Object)classLoader); clazz = clazz.getSuperclass()) {
                fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
            }
        }
    }

    private boolean isBasicType(String typeName) {
        return StrUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"byte") || StrUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"java.lang.Byte") || StrUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"char") || StrUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"java.lang.Character") || StrUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"short") || StrUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"java.lang.Short") || StrUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"int") || StrUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"java.lang.Integer") || StrUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"double") || StrUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"java.lang.Double") || StrUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"float") || StrUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"java.lang.Float") || StrUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"long") || StrUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"java.lang.Long") || StrUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"boolean") || StrUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"java.lang.Boolean") || StrUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"java.lang.String");
    }

    private static boolean isBasicTypeObj(Object o) {
        return o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Double || o instanceof Float || o instanceof Long || o instanceof Character || o instanceof Boolean || o instanceof String;
    }
}

