package com.lwq.sensitive.utils;

import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.AES;
import com.lwq.sensitive.constant.Constants;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

@Slf4j
public class SensitiveUtils {

    private static final String KEY = "1112223334445556";

    /**
     * 用户名保留第一个长度，其它变为星号
     *
     * SensitiveUtils.userName("张三丰") = 张**
     * SensitiveUtils.userName("abc") = a**
     * @param userName 用户名称
     * @return 脱敏后的名称
     */
    public static String userName(String userName) {
        if (StringUtils.isBlank(userName)) {
            return "";
        }
        final String name = StringUtils.left(userName, 1);
        return StringUtils.rightPad(name, StringUtils.length(userName), "*");
    }



    /**
     * 身份证号保留后四位
     *
     * SensitiveUtils.idCard("389656189512026328") = **************6328
     * @param idCard
     * @return 脱敏后的身份证号
     */
    public static String idCard(String idCard) {
        if (StringUtils.isBlank(idCard)) {
            return "";
        }

        return StringUtils.left(idCard, 3).concat(StringUtils
                .removeStart(StringUtils.leftPad(StringUtils.right(idCard, 3), StringUtils.length(idCard), "*"),
                        "***"));
    }


    /**
     * 手机号码保留 前三位，后四位
     * SensitiveUtils.phone("15658963369") = 156****3369
     * @param phoneNum
     * @return 脱敏后的手机号
     */
    public static String phone(String phoneNum) {
        if (StringUtils.isBlank(phoneNum)) {
            return "";
        }
        return StringUtils.left(phoneNum, 2).concat(StringUtils
                .removeStart(StringUtils.leftPad(StringUtils.right(phoneNum, 2), StringUtils.length(phoneNum), "*"),
                        "***"));

    }




    /**
     * 邮箱前缀仅显示第一个字母，前缀其他隐藏，用星号代替，@及后面的地址显示
     * SensitiveUtils.email("1563870065@qq.com") = 1*********@qq.com
     * @param email
     * @return
     */
    public static String email(String email) {
        if (StringUtils.isBlank(email)) {
            return "";
        }
        final int index = StringUtils.indexOf(email, "@");
        if (index <= 1) {
            return email;
        } else {
            return StringUtils.rightPad(StringUtils.left(email, 1), index, "*")
                    .concat(StringUtils.mid(email, index, StringUtils.length(email)));
        }
    }


    /**
     * 银行卡号 保留前六位，后四位
     *  SensitiveUtils.bankCard("111122565898563333") = 111122********3333
     * @param cardNum
     * @return 脱敏后的银行卡号
     */
    public static String bankCard(String cardNum) {
        if (StringUtils.isBlank(cardNum)) {
            return "";
        }
        return StringUtils.left(cardNum, 6).concat(StringUtils.removeStart(
                StringUtils.leftPad(StringUtils.right(cardNum, 4), StringUtils.length(cardNum), "*"),
                "******"));
    }


    /**
     * 加密
     *
     * @param obj
     * @return
     */
    public static String encrypt(Object obj){
        if (Objects.isNull(obj)){
            return null;
        }
        AES aes = SecureUtil.aes(KEY.getBytes());
        try{
            String value = obj.toString();
            if (value.length() >= Constants.PRE_FIX.length()){
                String sub = StrUtil.sub(value, 0, Constants.PRE_FIX.length());
                if (StrUtil.equals(sub, Constants.PRE_FIX)){
                    return value;
                }
            }
            return StrBuilder.create(Constants.PRE_FIX)
                    .append(aes.encryptBase64(obj.toString().getBytes()))
                    .toString();
        }catch (Exception e){
        }
        String encrypt = StrBuilder.create(Constants.PRE_FIX)
                .append(obj.toString())
                .toString();
        return encrypt;
    }

    /**
     * 解密
     *
     * @param str
     * @return
     */
    public static String decrypt(String str){
        if (StrUtil.isBlank(str)){
            return null;
        }
        AES aes = SecureUtil.aes(KEY.getBytes());
        try{
            String decryptStr = null;
            if (str.contains(Constants.PRE_FIX)){
                decryptStr = str.substring(Constants.PRE_FIX.length(), str.length());
            }
            return aes.decryptStr(decryptStr);
        }catch (Exception e){
        }
        return str;
    }


}
