package com.lwq.sensitive.annotation;


import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface SensitiveEnable {

    /**
     * 是否开启环绕通知切面
     */
    boolean enableAround() default true;

    /**
     * 是否开启返回后置通知切面
     */
    boolean enableAfterReturning() default true;

    /**
     * 是否扩展启用权限控制，如果设置为true ,需要自己实现 com.lwq.sensitive.support.PermissionSupport 这个接口，用于判断是否执行脱敏
     */
    boolean enablePermissionSupport() default false;

    /**
     * 当enablePermissionSupport 开启为true时，对应 PermissionSupport 接口的实现类的bean名称
     */
    String permissionSupportBeanName() default "permissionSupportImpl";

}
