/*
 * Decompiled with CFR 0.152.
 */
package com.lwq.eureka.grayscale.gray;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.base.Optional;
import com.lwq.eureka.grayscale.gray.EurekaMetaDataContext;
import com.lwq.eureka.grayscale.gray.EurekaMetaDataContextHolder;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomEurekaMetadataRule
extends ZoneAvoidanceRule {
    private static final Logger log = LoggerFactory.getLogger(CustomEurekaMetadataRule.class);

    public Server choose(Object key) {
        Optional server;
        EurekaMetaDataContext context = EurekaMetaDataContextHolder.getContext();
        Map<String, String> attributes = context.getEurekaMateMap();
        String grayName = attributes.get("app-gray-name");
        List allServerList = this.getLoadBalancer().getAllServers();
        if (CollectionUtil.isEmpty((Collection)allServerList)) {
            return null;
        }
        ArrayList<Server> matchedServerList = new ArrayList<Server>();
        ArrayList<Server> notMatchedServerList = new ArrayList<Server>();
        this.doMatches(grayName, allServerList, matchedServerList, notMatchedServerList);
        if (!matchedServerList.isEmpty() && (server = this.getPredicate().chooseRoundRobinAfterFiltering(matchedServerList, key)).isPresent()) {
            return (Server)server.get();
        }
        if (!notMatchedServerList.isEmpty() && (server = this.getPredicate().chooseRoundRobinAfterFiltering(notMatchedServerList, key)).isPresent()) {
            return (Server)server.get();
        }
        return null;
    }

    private void doMatches(String grayName, List<Server> allServerList, List<Server> matchedServerList, List<Server> notMatchedServerList) {
        for (Server server : allServerList) {
            if (!(server instanceof DiscoveryEnabledServer)) continue;
            DiscoveryEnabledServer discoveryEnabledServer = (DiscoveryEnabledServer)server;
            Map metadata = discoveryEnabledServer.getInstanceInfo().getMetadata();
            String metaGrayName = (String)metadata.get("app-gray-name");
            if (StrUtil.isBlank((CharSequence)metaGrayName)) {
                notMatchedServerList.add(server);
                continue;
            }
            if (StrUtil.isNotBlank((CharSequence)grayName) && StrUtil.equals((CharSequence)grayName, (CharSequence)metaGrayName)) {
                matchedServerList.add(server);
                continue;
            }
            notMatchedServerList.add(server);
        }
    }
}

