/*
 * Decompiled with CFR 0.152.
 */
package com.lwq.eureka.grayscale.filter;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.lwq.eureka.grayscale.gray.EurekaMetaDataContextHolder;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Configuration
public class WebFluxFilter
implements WebFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(WebFluxFilter.class);

    public Mono<Void> filter(ServerWebExchange serverWebExchange, WebFilterChain webFilterChain) {
        String grayName;
        ServerHttpRequest request = serverWebExchange.getRequest();
        List grayNameList = request.getHeaders().get((Object)"app-gray-name");
        if (CollectionUtil.isNotEmpty((Collection)grayNameList) && StrUtil.isNotBlank((CharSequence)(grayName = (String)grayNameList.get(0)))) {
            EurekaMetaDataContextHolder.getContext().put("app-gray-name", grayName);
        }
        return webFilterChain.filter(serverWebExchange).doOnError(e -> log.info("filter error", e)).doOnSuccess(result -> log.info("filter success result={}", result)).doFinally(onFinally -> {
            EurekaMetaDataContextHolder.remove();
            log.info("finally onFinally={}", onFinally);
        });
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

