/*
 * Decompiled with CFR 0.152.
 */
package com.lwq.eureka.grayscale.filter;

import cn.hutool.core.util.StrUtil;
import com.lwq.eureka.grayscale.gray.EurekaMetaDataContextHolder;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletHeaderFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ServletHeaderFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            String grayName = request.getHeader("app-gray-name");
            if (StrUtil.isNotBlank((CharSequence)grayName)) {
                EurekaMetaDataContextHolder.getContext().put("app-gray-name", grayName);
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        catch (Exception e) {
            log.error("GrayHeaderNameFilter doFilter error", (Throwable)e);
        }
        finally {
            EurekaMetaDataContextHolder.remove();
        }
    }

    public void destroy() {
        EurekaMetaDataContextHolder.remove();
    }
}

