/*
 * Decompiled with CFR 0.152.
 */
package com.lwq.eureka.grayscale.feign;

import com.lwq.eureka.grayscale.config.EurekaGrayAutoConfiguration;
import com.lwq.eureka.grayscale.gray.EurekaMetaDataContextHolder;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@AutoConfigureBefore(value={EurekaGrayAutoConfiguration.class})
@Order(value=1)
public class FeignInterceptor
implements RequestInterceptor {
    public void apply(RequestTemplate requestTemplate) {
        String grayName = EurekaMetaDataContextHolder.getContext().get("app-gray-name");
        requestTemplate.header("app-gray-name", new String[]{grayName});
    }
}

